/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.mail.spf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.rpcnet.securitytoolkit.mail.spf.SPFElement;
import net.rpcnet.securitytoolkit.mail.spf.SPFQualifier;
import net.rpcnet.securitytoolkit.mail.spf.SPFResult;
import org.immutables.value.Generated;

@Generated(from="SPFResult", generator="Immutables")
public final class ImmutableSPFResult
extends SPFResult {
    private final Integer version;
    private final SPFQualifier mailExchangeQualifier;
    private final SPFQualifier aQualifier;
    private final List<SPFElement> ip4Records;
    private final List<SPFElement> ip6Records;
    private final SPFQualifier allQualifier;
    private final List<SPFElement> includeRecords;

    private ImmutableSPFResult(Integer version, SPFQualifier mailExchangeQualifier, SPFQualifier aQualifier, List<SPFElement> ip4Records, List<SPFElement> ip6Records, SPFQualifier allQualifier, List<SPFElement> includeRecords) {
        this.version = version;
        this.mailExchangeQualifier = mailExchangeQualifier;
        this.aQualifier = aQualifier;
        this.ip4Records = ip4Records;
        this.ip6Records = ip6Records;
        this.allQualifier = allQualifier;
        this.includeRecords = includeRecords;
    }

    @Override
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public Optional<SPFQualifier> getMailExchangeQualifier() {
        return Optional.ofNullable(this.mailExchangeQualifier);
    }

    @Override
    public Optional<SPFQualifier> getAQualifier() {
        return Optional.ofNullable(this.aQualifier);
    }

    @Override
    public List<SPFElement> getIp4Records() {
        return this.ip4Records;
    }

    @Override
    public List<SPFElement> getIp6Records() {
        return this.ip6Records;
    }

    @Override
    public Optional<SPFQualifier> getAllQualifier() {
        return Optional.ofNullable(this.allQualifier);
    }

    @Override
    public List<SPFElement> getIncludeRecords() {
        return this.includeRecords;
    }

    public final ImmutableSPFResult withVersion(int value) {
        Integer newValue = value;
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableSPFResult(newValue, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withVersion(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableSPFResult(value, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withMailExchangeQualifier(SPFQualifier value) {
        SPFQualifier newValue = Objects.requireNonNull(value, "mailExchangeQualifier");
        if (this.mailExchangeQualifier == newValue) {
            return this;
        }
        return new ImmutableSPFResult(this.version, newValue, this.aQualifier, this.ip4Records, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withMailExchangeQualifier(Optional<? extends SPFQualifier> optional) {
        SPFQualifier value = optional.orElse(null);
        if (Objects.equals((Object)this.mailExchangeQualifier, (Object)value)) {
            return this;
        }
        return new ImmutableSPFResult(this.version, value, this.aQualifier, this.ip4Records, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withAQualifier(SPFQualifier value) {
        SPFQualifier newValue = Objects.requireNonNull(value, "aQualifier");
        if (this.aQualifier == newValue) {
            return this;
        }
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, newValue, this.ip4Records, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withAQualifier(Optional<? extends SPFQualifier> optional) {
        SPFQualifier value = optional.orElse(null);
        if (Objects.equals((Object)this.aQualifier, (Object)value)) {
            return this;
        }
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, value, this.ip4Records, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withIp4Records(SPFElement ... elements) {
        List<SPFElement> newValue = ImmutableSPFResult.createUnmodifiableList(false, ImmutableSPFResult.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, newValue, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withIp4Records(Iterable<? extends SPFElement> elements) {
        if (this.ip4Records == elements) {
            return this;
        }
        List<SPFElement> newValue = ImmutableSPFResult.createUnmodifiableList(false, ImmutableSPFResult.createSafeList(elements, true, false));
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, newValue, this.ip6Records, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withIp6Records(SPFElement ... elements) {
        List<SPFElement> newValue = ImmutableSPFResult.createUnmodifiableList(false, ImmutableSPFResult.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, newValue, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withIp6Records(Iterable<? extends SPFElement> elements) {
        if (this.ip6Records == elements) {
            return this;
        }
        List<SPFElement> newValue = ImmutableSPFResult.createUnmodifiableList(false, ImmutableSPFResult.createSafeList(elements, true, false));
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, newValue, this.allQualifier, this.includeRecords);
    }

    public final ImmutableSPFResult withAllQualifier(SPFQualifier value) {
        SPFQualifier newValue = Objects.requireNonNull(value, "allQualifier");
        if (this.allQualifier == newValue) {
            return this;
        }
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, this.ip6Records, newValue, this.includeRecords);
    }

    public final ImmutableSPFResult withAllQualifier(Optional<? extends SPFQualifier> optional) {
        SPFQualifier value = optional.orElse(null);
        if (Objects.equals((Object)this.allQualifier, (Object)value)) {
            return this;
        }
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, this.ip6Records, value, this.includeRecords);
    }

    public final ImmutableSPFResult withIncludeRecords(SPFElement ... elements) {
        List<SPFElement> newValue = ImmutableSPFResult.createUnmodifiableList(false, ImmutableSPFResult.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, this.ip6Records, this.allQualifier, newValue);
    }

    public final ImmutableSPFResult withIncludeRecords(Iterable<? extends SPFElement> elements) {
        if (this.includeRecords == elements) {
            return this;
        }
        List<SPFElement> newValue = ImmutableSPFResult.createUnmodifiableList(false, ImmutableSPFResult.createSafeList(elements, true, false));
        return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, this.ip4Records, this.ip6Records, this.allQualifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSPFResult && this.equalTo((ImmutableSPFResult)another);
    }

    private boolean equalTo(ImmutableSPFResult another) {
        return Objects.equals(this.version, another.version) && Objects.equals((Object)this.mailExchangeQualifier, (Object)another.mailExchangeQualifier) && Objects.equals((Object)this.aQualifier, (Object)another.aQualifier) && this.ip4Records.equals(another.ip4Records) && this.ip6Records.equals(another.ip6Records) && Objects.equals((Object)this.allQualifier, (Object)another.allQualifier) && this.includeRecords.equals(another.includeRecords);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode((Object)this.mailExchangeQualifier);
        h += (h << 5) + Objects.hashCode((Object)this.aQualifier);
        h += (h << 5) + this.ip4Records.hashCode();
        h += (h << 5) + this.ip6Records.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.allQualifier);
        h += (h << 5) + this.includeRecords.hashCode();
        return h;
    }

    public static ImmutableSPFResult copyOf(SPFResult instance) {
        if (instance instanceof ImmutableSPFResult) {
            return (ImmutableSPFResult)instance;
        }
        return ImmutableSPFResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SPFResult", generator="Immutables")
    public static final class Builder {
        private Integer version;
        private SPFQualifier mailExchangeQualifier;
        private SPFQualifier aQualifier;
        private List<SPFElement> ip4Records = new ArrayList<SPFElement>();
        private List<SPFElement> ip6Records = new ArrayList<SPFElement>();
        private SPFQualifier allQualifier;
        private List<SPFElement> includeRecords = new ArrayList<SPFElement>();

        private Builder() {
        }

        public final Builder from(SPFResult instance) {
            Optional<SPFQualifier> aQualifierOptional;
            Optional<SPFQualifier> mailExchangeQualifierOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Integer> versionOptional = instance.getVersion();
            if (versionOptional.isPresent()) {
                this.version(versionOptional);
            }
            if ((mailExchangeQualifierOptional = instance.getMailExchangeQualifier()).isPresent()) {
                this.mailExchangeQualifier(mailExchangeQualifierOptional);
            }
            if ((aQualifierOptional = instance.getAQualifier()).isPresent()) {
                this.aQualifier(aQualifierOptional);
            }
            this.addAllIp4Records(instance.getIp4Records());
            this.addAllIp6Records(instance.getIp6Records());
            Optional<SPFQualifier> allQualifierOptional = instance.getAllQualifier();
            if (allQualifierOptional.isPresent()) {
                this.allQualifier(allQualifierOptional);
            }
            this.addAllIncludeRecords(instance.getIncludeRecords());
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            return this;
        }

        public final Builder version(Optional<Integer> version) {
            this.version = version.orElse(null);
            return this;
        }

        public final Builder mailExchangeQualifier(SPFQualifier mailExchangeQualifier) {
            this.mailExchangeQualifier = Objects.requireNonNull(mailExchangeQualifier, "mailExchangeQualifier");
            return this;
        }

        public final Builder mailExchangeQualifier(Optional<? extends SPFQualifier> mailExchangeQualifier) {
            this.mailExchangeQualifier = mailExchangeQualifier.orElse(null);
            return this;
        }

        public final Builder aQualifier(SPFQualifier aQualifier) {
            this.aQualifier = Objects.requireNonNull(aQualifier, "aQualifier");
            return this;
        }

        public final Builder aQualifier(Optional<? extends SPFQualifier> aQualifier) {
            this.aQualifier = aQualifier.orElse(null);
            return this;
        }

        public final Builder addIp4Records(SPFElement element) {
            this.ip4Records.add(Objects.requireNonNull(element, "ip4Records element"));
            return this;
        }

        public final Builder addIp4Records(SPFElement ... elements) {
            for (SPFElement element : elements) {
                this.ip4Records.add(Objects.requireNonNull(element, "ip4Records element"));
            }
            return this;
        }

        public final Builder ip4Records(Iterable<? extends SPFElement> elements) {
            this.ip4Records.clear();
            return this.addAllIp4Records(elements);
        }

        public final Builder addAllIp4Records(Iterable<? extends SPFElement> elements) {
            for (SPFElement sPFElement : elements) {
                this.ip4Records.add(Objects.requireNonNull(sPFElement, "ip4Records element"));
            }
            return this;
        }

        public final Builder addIp6Records(SPFElement element) {
            this.ip6Records.add(Objects.requireNonNull(element, "ip6Records element"));
            return this;
        }

        public final Builder addIp6Records(SPFElement ... elements) {
            for (SPFElement element : elements) {
                this.ip6Records.add(Objects.requireNonNull(element, "ip6Records element"));
            }
            return this;
        }

        public final Builder ip6Records(Iterable<? extends SPFElement> elements) {
            this.ip6Records.clear();
            return this.addAllIp6Records(elements);
        }

        public final Builder addAllIp6Records(Iterable<? extends SPFElement> elements) {
            for (SPFElement sPFElement : elements) {
                this.ip6Records.add(Objects.requireNonNull(sPFElement, "ip6Records element"));
            }
            return this;
        }

        public final Builder allQualifier(SPFQualifier allQualifier) {
            this.allQualifier = Objects.requireNonNull(allQualifier, "allQualifier");
            return this;
        }

        public final Builder allQualifier(Optional<? extends SPFQualifier> allQualifier) {
            this.allQualifier = allQualifier.orElse(null);
            return this;
        }

        public final Builder addIncludeRecords(SPFElement element) {
            this.includeRecords.add(Objects.requireNonNull(element, "includeRecords element"));
            return this;
        }

        public final Builder addIncludeRecords(SPFElement ... elements) {
            for (SPFElement element : elements) {
                this.includeRecords.add(Objects.requireNonNull(element, "includeRecords element"));
            }
            return this;
        }

        public final Builder includeRecords(Iterable<? extends SPFElement> elements) {
            this.includeRecords.clear();
            return this.addAllIncludeRecords(elements);
        }

        public final Builder addAllIncludeRecords(Iterable<? extends SPFElement> elements) {
            for (SPFElement sPFElement : elements) {
                this.includeRecords.add(Objects.requireNonNull(sPFElement, "includeRecords element"));
            }
            return this;
        }

        public ImmutableSPFResult build() {
            return new ImmutableSPFResult(this.version, this.mailExchangeQualifier, this.aQualifier, ImmutableSPFResult.createUnmodifiableList(true, this.ip4Records), ImmutableSPFResult.createUnmodifiableList(true, this.ip6Records), this.allQualifier, ImmutableSPFResult.createUnmodifiableList(true, this.includeRecords));
        }
    }
}

