/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.mail.spf;

import java.util.ArrayList;
import java.util.Objects;
import net.rpcnet.securitytoolkit.mail.spf.SPFElement;
import net.rpcnet.securitytoolkit.mail.spf.SPFQualifier;
import org.immutables.value.Generated;

@Generated(from="SPFElement", generator="Immutables")
public final class ImmutableSPFElement
implements SPFElement {
    private final SPFQualifier qualifier;
    private final String value;

    private ImmutableSPFElement(SPFQualifier qualifier, String value) {
        this.qualifier = qualifier;
        this.value = value;
    }

    @Override
    public SPFQualifier getQualifier() {
        return this.qualifier;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public final ImmutableSPFElement withQualifier(SPFQualifier value) {
        if (this.qualifier == value) {
            return this;
        }
        SPFQualifier newValue = Objects.requireNonNull(value, "qualifier");
        if (this.qualifier.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSPFElement(newValue, this.value);
    }

    public final ImmutableSPFElement withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableSPFElement(this.qualifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSPFElement && this.equalTo((ImmutableSPFElement)another);
    }

    private boolean equalTo(ImmutableSPFElement another) {
        return this.qualifier.equals((Object)another.qualifier) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.qualifier.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "SPFElement{qualifier=" + this.qualifier + ", value=" + this.value + "}";
    }

    public static ImmutableSPFElement copyOf(SPFElement instance) {
        if (instance instanceof ImmutableSPFElement) {
            return (ImmutableSPFElement)instance;
        }
        return ImmutableSPFElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SPFElement", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_QUALIFIER = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private SPFQualifier qualifier;
        private String value;

        private Builder() {
        }

        public final Builder from(SPFElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.qualifier(instance.getQualifier());
            this.value(instance.getValue());
            return this;
        }

        public final Builder qualifier(SPFQualifier qualifier) {
            this.qualifier = Objects.requireNonNull(qualifier, "qualifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSPFElement build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSPFElement(this.qualifier, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("qualifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build SPFElement, some of required attributes are not set " + attributes;
        }
    }
}

