/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.mail.dmarc;

import java.util.ArrayList;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class DMARCResult {
    public static final String EQUAL_SIGN = "=";

    public abstract Optional<String> getVersion();

    public abstract Optional<String> getPercentage();

    public abstract Optional<String> getForensicReport();

    public abstract Optional<String> getAggregateReport();

    public abstract Optional<String> getPolicy();

    public abstract Optional<String> getSubdomainsPolicy();

    public abstract Optional<String> getDomainKeysAlignment();

    public abstract Optional<String> getSPFAlignment();

    public abstract Optional<String> getReportFormat();

    public abstract Optional<String> getAggregateReportTimeInterval();

    public abstract Optional<String> getForensicReportingOptions();

    public String toString() {
        ArrayList list = new ArrayList();
        this.getVersion().ifPresent(s -> list.add("v=" + s));
        this.getPercentage().ifPresent(s -> list.add("pct=" + s));
        this.getForensicReport().ifPresent(s -> list.add("ruf=" + s));
        this.getAggregateReport().ifPresent(s -> list.add("rua=" + s));
        this.getPolicy().ifPresent(s -> list.add("p=" + s));
        this.getSubdomainsPolicy().ifPresent(s -> list.add("sp=" + s));
        this.getDomainKeysAlignment().ifPresent(s -> list.add("adkim=" + s));
        this.getSPFAlignment().ifPresent(s -> list.add("aspf=" + s));
        this.getReportFormat().ifPresent(s -> list.add("rf=" + s));
        this.getAggregateReportTimeInterval().ifPresent(s -> list.add("ri=" + s));
        this.getForensicReportingOptions().ifPresent(s -> list.add("fo=" + s));
        return String.join((CharSequence)";", list);
    }
}

