/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.mail.dmarc;

import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import net.rpcnet.securitytoolkit.mail.dmarc.DMARCResult;
import net.rpcnet.securitytoolkit.mail.dmarc.ImmutableDMARCResult;

public final class DMARCParser {
    public static final String PROPERTIES_DELIMITER = "=";

    private DMARCParser() {
    }

    public static Optional<DMARCResult> parseDMARCResponse(String dmarcResponse) {
        return DMARCParser.parseDMARCResponse(DMARCParser.parseDMARCProperties(dmarcResponse));
    }

    public static Properties parseDMARCProperties(String dnsResponse) {
        StringTokenizer stringTokenizer = new StringTokenizer(dnsResponse, ";");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreTokens()) {
            String[] split = stringTokenizer.nextToken().split(PROPERTIES_DELIMITER);
            properties.put(split[0], split[1]);
        }
        return properties;
    }

    public static Optional<DMARCResult> parseDMARCResponse(Properties properties) {
        if (properties.isEmpty()) {
            return Optional.empty();
        }
        ImmutableDMARCResult.Builder builder = DMARCParser.getBuilder();
        boolean result = DMARCParser.handleVersion(properties, builder);
        result |= DMARCParser.handlePercentage(properties, builder);
        result |= DMARCParser.handleForensicReport(properties, builder);
        result |= DMARCParser.handleAggregateReport(properties, builder);
        result |= DMARCParser.handlePolicy(properties, builder);
        result |= DMARCParser.handleSubdomainsPolicy(properties, builder);
        result |= DMARCParser.handleDomainKeysAlignment(properties, builder);
        result |= DMARCParser.handleSPFAlignment(properties, builder);
        result |= DMARCParser.handleForensicReportingOptions(properties, builder);
        result |= DMARCParser.handleReportFormat(properties, builder);
        return (result |= DMARCParser.handleAggregateReportTimeInterval(properties, builder)) ? Optional.of(builder.build()) : Optional.empty();
    }

    private static ImmutableDMARCResult.Builder getBuilder() {
        ImmutableDMARCResult.Builder builder = ImmutableDMARCResult.builder();
        builder.version(Optional.empty());
        builder.percentage(Optional.empty());
        builder.forensicReport(Optional.empty());
        builder.aggregateReport(Optional.empty());
        builder.policy(Optional.empty());
        builder.subdomainsPolicy(Optional.empty());
        builder.domainKeysAlignment(Optional.empty());
        builder.sPFAlignment(Optional.empty());
        builder.forensicReportingOptions(Optional.empty());
        builder.reportFormat(Optional.empty());
        builder.aggregateReportTimeInterval(Optional.empty());
        return builder;
    }

    private static boolean handleAggregateReportTimeInterval(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("ri") && properties.getProperty("ri") != null) {
            builder.aggregateReportTimeInterval(properties.getProperty("ri"));
            return true;
        }
        return false;
    }

    private static boolean handleReportFormat(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("rf") && properties.getProperty("rf") != null) {
            builder.reportFormat(properties.getProperty("rf"));
            return true;
        }
        return false;
    }

    private static boolean handleForensicReportingOptions(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("fo") && properties.getProperty("fo") != null) {
            builder.forensicReportingOptions(properties.getProperty("fo"));
            return true;
        }
        return false;
    }

    private static boolean handleSPFAlignment(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("aspf") && properties.getProperty("aspf") != null) {
            builder.sPFAlignment(properties.getProperty("aspf"));
            return true;
        }
        return false;
    }

    private static boolean handleDomainKeysAlignment(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("adkim") && properties.getProperty("adkim") != null) {
            builder.domainKeysAlignment(properties.getProperty("adkim"));
            return true;
        }
        return false;
    }

    private static boolean handleSubdomainsPolicy(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("sp") && properties.getProperty("sp") != null) {
            builder.subdomainsPolicy(properties.getProperty("sp"));
            return true;
        }
        return false;
    }

    private static boolean handlePolicy(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("p") && properties.getProperty("p") != null) {
            builder.policy(properties.getProperty("p"));
            return true;
        }
        return false;
    }

    private static boolean handleAggregateReport(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("rua") && properties.getProperty("rua") != null) {
            builder.aggregateReport(properties.getProperty("rua"));
            return true;
        }
        return false;
    }

    private static boolean handleForensicReport(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("ruf") && properties.getProperty("ruf") != null) {
            builder.forensicReport(properties.getProperty("ruf"));
            return true;
        }
        return false;
    }

    private static boolean handlePercentage(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("pct") && properties.getProperty("pct") != null) {
            builder.percentage(properties.getProperty("pct"));
            return true;
        }
        return false;
    }

    private static boolean handleVersion(Properties properties, ImmutableDMARCResult.Builder builder) {
        if (properties.containsKey("v") && properties.getProperty("v") != null) {
            builder.version(properties.getProperty("v"));
            return true;
        }
        return false;
    }
}

