/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.mail.dmarc;

import java.util.Objects;
import java.util.Optional;
import net.rpcnet.securitytoolkit.common.dns.RecordChecker;
import net.rpcnet.securitytoolkit.mail.dmarc.DMARCParser;
import net.rpcnet.securitytoolkit.mail.dmarc.DMARCResult;

public class DMARCChecker {
    private static final String DMARC_FORMAT = "_dmarc.%s";

    private DMARCChecker() {
    }

    public static Optional<DMARCResult> getDMARC(String domain) {
        String dnsResponse = Objects.requireNonNull(RecordChecker.getTXT((String)DMARC_FORMAT, (String)domain)).stream().findFirst().orElse(null);
        return DMARCChecker.getDmarcResult(dnsResponse);
    }

    public static Optional<DMARCResult> getDmarcResult(String dnsResponse) {
        if (dnsResponse == null || dnsResponse.isEmpty() || dnsResponse.isBlank()) {
            return Optional.empty();
        }
        return DMARCParser.parseDMARCResponse(dnsResponse);
    }
}

