/*
 * Decompiled with CFR 0.152.
 */
package net.rpcnet.securitytoolkit.common.dns;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.CAARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public final class RecordChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordChecker.class);

    private RecordChecker() {
    }

    public static Collection<CAADto> getCAA(String domain) {
        return RecordChecker.getCAA("%s", domain);
    }

    public static Collection<String> getTXT(String domain) {
        return RecordChecker.getTXT("%s", domain);
    }

    public static Collection<String> getTXT(String format, String domain) {
        String testingDomain = String.format(format, domain);
        ArrayList<String> result = new ArrayList<String>();
        try {
            Lookup lookup = new Lookup(testingDomain, 16);
            lookup.setResolver((Resolver)new SimpleResolver());
            lookup.setCache(null);
            Record[] records = lookup.run();
            if (lookup.getResult() == 0) {
                for (Record record : records) {
                    TXTRecord txt = (TXTRecord)record;
                    result.addAll(txt.getStrings());
                }
            }
        }
        catch (UnknownHostException | TextParseException e) {
            LOGGER.error("Error processing the DNS Query: ", e);
        }
        return result;
    }

    public static Collection<CAADto> getCAA(String format, String domain) {
        String testingDomain = String.format(format, domain);
        ArrayList<CAADto> result = new ArrayList<CAADto>();
        try {
            Lookup lookup = new Lookup(testingDomain, 257);
            lookup.setResolver((Resolver)new SimpleResolver());
            lookup.setCache(null);
            Record[] records = lookup.run();
            if (lookup.getResult() == 0) {
                for (Record record : records) {
                    CAARecord caa = (CAARecord)record;
                    result.add(new CAADto(caa.getValue(), caa.getFlags(), caa.getTag()));
                }
            }
        }
        catch (UnknownHostException | TextParseException e) {
            LOGGER.error("Error processing the DNS Query: ", e);
        }
        return result;
    }

    public static final class CAADto {
        private final String value;
        private final int flags;
        private final String tag;

        public CAADto(String value, int flags, String tag) {
            this.value = value;
            this.flags = flags;
            this.tag = tag;
        }

        public String getValue() {
            return this.value;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

