/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.sshd.internal;

import java.security.PublicKey;
import java.util.Map;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.rossonet.rpc.PasswordAuthenticationProvider;
import org.rossonet.sshd.MinaSshServer;

public class InternalPublickeyAuthenticator
implements PublickeyAuthenticator {
    private final MinaSshServer sshServer;

    public InternalPublickeyAuthenticator(MinaSshServer sshServer) {
        this.sshServer = sshServer;
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) throws AsyncAuthException {
        for (PasswordAuthenticationProvider passwordAuthenticationProvider : this.sshServer.getPasswordAuthenticationProviders()) {
            if (!passwordAuthenticationProvider.authenticate(username, key)) continue;
            Map<String, String> sessionData = passwordAuthenticationProvider.getSessionData();
            if (sessionData != null && !sessionData.isEmpty()) {
                session.setAttribute(new AttributeRepository.AttributeKey(), sessionData);
            }
            return true;
        }
        return false;
    }
}

