/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.sshd.internal;

import java.util.Map;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;
import org.rossonet.rpc.PasswordAuthenticationProvider;
import org.rossonet.sshd.MinaSshServer;

public class InternalPasswordAuthenticator
implements PasswordAuthenticator {
    private final MinaSshServer sshServer;

    public InternalPasswordAuthenticator(MinaSshServer sshServer) {
        this.sshServer = sshServer;
    }

    public boolean authenticate(String username, String password, ServerSession session) throws PasswordChangeRequiredException, AsyncAuthException {
        for (PasswordAuthenticationProvider passwordAuthenticationProvider : this.sshServer.getPasswordAuthenticationProviders()) {
            if (!passwordAuthenticationProvider.authenticate(username, password)) continue;
            Map<String, String> sessionData = passwordAuthenticationProvider.getSessionData();
            if (sessionData != null && !sessionData.isEmpty()) {
                session.setAttribute(new AttributeRepository.AttributeKey(), sessionData);
            }
            return true;
        }
        return false;
    }
}

