/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.sshd;

import org.rossonet.sshd.MinaSshServer;

final class SshServerThread
extends Thread {
    private final MinaSshServer sshServer;
    private boolean forceStopped = false;

    public SshServerThread(MinaSshServer sshServer) {
        this.sshServer = sshServer;
    }

    public void forceStop() {
        this.forceStopped = true;
    }

    @Override
    public void run() {
        this.setName(this.sshServer.getConfiguration().getSshServerThreadName());
        this.setPriority(this.sshServer.getConfiguration().getSshServerThreadPriority());
        while (!this.forceStopped) {
            try {
                this.sshServer.periodicalThreadAction();
                Thread.sleep(this.sshServer.getConfiguration().getSshServerThreadSleepingTimeMs());
            }
            catch (Throwable error) {
                this.sshServer.fireServerException(error);
            }
        }
    }
}

