/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.sshd;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.rossonet.rpc.PasswordAuthenticationProvider;
import org.rossonet.rpc.RpcEngine;
import org.rossonet.sshd.BaseSshServer;
import org.rossonet.sshd.BaseSshServerStatus;
import org.rossonet.sshd.SshServerObserver;
import org.rossonet.sshd.SshServerStatus;
import org.rossonet.sshd.SshServerThread;
import org.rossonet.sshd.WatchDogTask;
import org.rossonet.sshd.internal.InternalExecutorService;
import org.rossonet.sshd.internal.InternalForwardingFilter;
import org.rossonet.sshd.internal.InternalPasswordAuthenticator;
import org.rossonet.sshd.internal.InternalPublickeyAuthenticator;
import org.rossonet.sshd.internal.InternalServerBuilder;
import org.rossonet.sshd.internal.InternalShellFactory;
import org.rossonet.sshd.internal.PortForwarderManager;
import org.rossonet.sshd.internal.SshServerConfiguration;

public class MinaSshServer
implements BaseSshServer {
    private final SshServerConfiguration configuration;
    private final SshServerStatus status;
    private SshServerThread thread;
    private final PortForwarderManager portForwarderManager;
    private final Set<SshServerObserver> throwableObservers = new HashSet<SshServerObserver>();
    private final Set<WatchDogTask> watchDogs = new HashSet<WatchDogTask>();
    private SshServer server;
    private final Set<PasswordAuthenticationProvider> passwordAuthenticationProviders = new HashSet<PasswordAuthenticationProvider>();
    private final RpcEngine rpcEngine;

    public MinaSshServer(SshServerConfiguration configuration, RpcEngine rpcEngine) {
        this(configuration, rpcEngine, new BaseSshServerStatus());
    }

    public MinaSshServer(SshServerConfiguration configuration, RpcEngine rpcEngine, SshServerStatus serverStatus) {
        this.status = serverStatus;
        this.status.setState(SshServerStatus.State.INIT);
        this.rpcEngine = rpcEngine;
        this.portForwarderManager = new PortForwarderManager(this);
        this.configuration = configuration;
        if (this.configuration.isValid()) {
            this.status.setState(SshServerStatus.State.CONFIGURED);
        } else {
            this.status.setState(SshServerStatus.State.CONFIGURATION_ERROR);
        }
    }

    private void cleanThreadIfNeeded() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.forceStop();
        }
    }

    @Override
    public void close() throws Exception {
        this.cleanThreadIfNeeded();
    }

    private SshServer createSshServer() {
        SshServer newserver = (SshServer)new InternalServerBuilder(this).build();
        newserver.setPort(this.configuration.getSshPort());
        newserver.setHost(this.configuration.getSshHost());
        newserver.setShellFactory((ShellFactory)new InternalShellFactory(this, this.rpcEngine));
        newserver.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        newserver.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.configuration.getServerBasePath()));
        newserver.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(this.configuration.getServerHostKeyPath()));
        newserver.setPublickeyAuthenticator((PublickeyAuthenticator)new InternalPublickeyAuthenticator(this));
        newserver.setPasswordAuthenticator((PasswordAuthenticator)new InternalPasswordAuthenticator(this));
        newserver.setScheduledExecutorService((ScheduledExecutorService)new InternalExecutorService(this), true);
        newserver.setForwardingFilter((ForwardingFilter)new InternalForwardingFilter(this));
        return newserver;
    }

    void fireServerException(Throwable error) {
        for (SshServerObserver throwableObserver : this.throwableObservers) {
            throwableObserver.fireException(error);
        }
    }

    void fireServerMessage(String message) {
        for (SshServerObserver throwableObserver : this.throwableObservers) {
            throwableObserver.fireMessage(message);
        }
    }

    @Override
    public SshServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public Set<PasswordAuthenticationProvider> getPasswordAuthenticationProviders() {
        return this.passwordAuthenticationProviders;
    }

    @Override
    public PortForwarderManager getPortForwarderManager() {
        return this.portForwarderManager;
    }

    public RpcEngine getRpcEngine() {
        return this.rpcEngine;
    }

    @Override
    public SshServerStatus getStatus() {
        return this.status;
    }

    private void internalFireWatchDogs() {
        for (WatchDogTask watchDog : this.watchDogs) {
            watchDog.checkSshServerState(this);
        }
    }

    private synchronized void internalStartedCheckAndAction() throws IOException {
        if (this.server == null || !this.server.isStarted()) {
            this.server = this.createSshServer();
            this.server.start();
        }
    }

    private void internalStoppedCheckAndAction() throws IOException, InterruptedException {
        if (this.server != null) {
            this.server.stop();
            this.server.close();
            this.server = null;
        }
    }

    void periodicalThreadAction() throws IOException, InterruptedException {
        switch (this.status.getState()) {
            case CONFIGURATION_ERROR: {
                this.internalFireWatchDogs();
                break;
            }
            case CONFIGURED: {
                this.internalFireWatchDogs();
                break;
            }
            case FAULT: {
                this.internalFireWatchDogs();
                break;
            }
            case INIT: {
                this.internalFireWatchDogs();
                break;
            }
            case STARTED: {
                this.internalStartedCheckAndAction();
                this.internalFireWatchDogs();
                break;
            }
            case STOPPED: {
                this.internalStoppedCheckAndAction();
                this.internalFireWatchDogs();
                break;
            }
            default: {
                this.fireServerException(new RuntimeException("ssh server status NOT know!"));
            }
        }
    }

    @Override
    public synchronized void start() {
        this.cleanThreadIfNeeded();
        this.thread = new SshServerThread(this);
        this.thread.start();
        this.status.setState(SshServerStatus.State.STARTED);
    }

    @Override
    public synchronized void stop() {
        this.cleanThreadIfNeeded();
        this.status.setState(SshServerStatus.State.STOPPED);
    }
}

