/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.rpc;

import java.io.InputStream;
import java.io.OutputStream;
import org.rossonet.rpc.RpcEngine;
import org.rossonet.rpc.ThreadShellSession;
import org.rossonet.rpc.exception.RpcException;

public abstract class ShellSession {
    private OutputStream errorStream;
    private OutputStream outputStream;
    private InputStream inputStream;
    private int minThreadPriority = 2;
    private int maxThreadPriority = 8;
    private final ThreadShellSession watchdog = new ThreadShellSession(this);
    private final RpcEngine rpcEngine;

    public ShellSession(RpcEngine rpcEngine) {
        this.rpcEngine = rpcEngine;
    }

    protected void destroyRpcSession() {
        this.watchdog.destroy();
    }

    public OutputStream getErrorStream() throws RpcException {
        return this.errorStream;
    }

    public InputStream getInputStream() throws RpcException {
        return this.inputStream;
    }

    public int getMaxThreadPriority() {
        return this.maxThreadPriority;
    }

    public int getMinThreadPriority() {
        return this.minThreadPriority;
    }

    public OutputStream getOutputStream() throws RpcException {
        return this.outputStream;
    }

    public RpcEngine getRpcEngine() {
        return this.rpcEngine;
    }

    public abstract String getSessionDescription();

    protected abstract String getThreadName();

    public int getThreadPriority() {
        return this.watchdog.getPriority();
    }

    public abstract boolean isByteSession();

    public abstract boolean isCharacterSession();

    public abstract boolean isLineSession();

    protected void pauseRpcSession() {
        this.watchdog.pause();
    }

    protected abstract void periodicalCall();

    protected void setErrorStream(OutputStream errorStream) {
        this.errorStream = errorStream;
    }

    protected void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected void setMaxThreadPriority(int maxThreadPriority) {
        this.maxThreadPriority = maxThreadPriority;
    }

    protected void setMinThreadPriority(int minThreadPriority) {
        this.minThreadPriority = minThreadPriority;
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setThreadPriority(int priority) {
        if (priority > this.maxThreadPriority) {
            this.watchdog.setPriority(this.maxThreadPriority);
        } else if (priority < this.minThreadPriority) {
            this.watchdog.setPriority(this.minThreadPriority);
        } else {
            this.watchdog.setPriority(priority);
        }
    }

    protected void startRpcSession() {
        if (!this.watchdog.isAlive()) {
            this.watchdog.start();
        } else {
            this.watchdog.removePause();
        }
    }
}

