/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.utils.concurrent;

import java.util.Comparator;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.rossonet.ext.utils.concurrent.PriorityBlockingDeque;
import org.rossonet.ext.utils.concurrent.PriorityExecutorService;
import org.rossonet.ext.utils.concurrent.PriorityFuture;

public class PriorityThreadPoolExecutor
extends ThreadPoolExecutor
implements PriorityExecutorService {
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();
    private final BlockingDeque<Runnable> workQueue = (BlockingDeque)super.getQueue();

    public PriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), defaultHandler);
    }

    public PriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), handler);
    }

    public PriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, defaultHandler);
    }

    public PriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new PriorityBlockingDeque<Runnable>(corePoolSize, new PriorityFutureTaskComparator()), threadFactory, handler);
    }

    @Override
    public void changePriorities(int fromPriority, int toPriority) {
        PriorityFuture[] tasks;
        if (fromPriority < 1 || fromPriority > 10 || toPriority < 1 || toPriority > 10 || fromPriority == toPriority) {
            throw new IllegalArgumentException("Invalid from/to priority values");
        }
        for (PriorityFuture task : tasks = this.workQueue.toArray(new PriorityFuture[0])) {
            if (task.getPriority() != fromPriority || !this.workQueue.remove(task)) continue;
            task.setPriority(toPriority);
            this.workQueue.offer(task);
        }
    }

    @Override
    public int getHighestPriority() {
        PriorityFuture task = (PriorityFuture)this.workQueue.peekFirst();
        return task != null ? task.getPriority() : Integer.MAX_VALUE;
    }

    @Override
    public int getLeastPriority() {
        PriorityFuture task = (PriorityFuture)this.workQueue.peekLast();
        return task != null ? task.getPriority() : Integer.MIN_VALUE;
    }

    protected <T> RunnableFuture<T> newPriorityTaskFor(Callable<T> callable, int priority) {
        return new PriorityFuture<T>(callable, priority);
    }

    protected <T> RunnableFuture<T> newPriorityTaskFor(Runnable runnable, T value, int priority) {
        return new PriorityFuture<T>(runnable, value, priority);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.submit(task, 5);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, int priority) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newPriorityTaskFor(task, priority);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, (Object)5);
    }

    @Override
    public Future<?> submit(Runnable task, int priority) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> ftask = this.newPriorityTaskFor(task, null, priority);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(task, result, 5);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result, int priority) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newPriorityTaskFor(task, result, priority);
        this.execute(ftask);
        return ftask;
    }

    private static class PriorityFutureTaskComparator<T extends PriorityFuture>
    implements Comparator<T> {
        private PriorityFutureTaskComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            return ((PriorityFuture)t2).getPriority() - ((PriorityFuture)t1).getPriority();
        }
    }
}

