/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.support.composite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.ext.rules.api.Rule;
import org.rossonet.ext.rules.support.composite.CompositeRule;

public class ConditionalRuleGroup
extends CompositeRule {
    private Set<Rule> successfulEvaluations;
    private Rule conditionalRule;

    public ConditionalRuleGroup() {
    }

    public ConditionalRuleGroup(String name) {
        super(name);
    }

    public ConditionalRuleGroup(String name, String description) {
        super(name, description);
    }

    public ConditionalRuleGroup(String name, String description, int priority) {
        super(name, description, priority);
    }

    @Override
    public boolean evaluate(Facts facts) {
        this.successfulEvaluations = new HashSet<Rule>();
        this.conditionalRule = this.getRuleWithHighestPriority();
        if (this.conditionalRule.evaluate(facts)) {
            for (Rule rule : this.rules) {
                if (rule == this.conditionalRule || !rule.evaluate(facts)) continue;
                this.successfulEvaluations.add(rule);
            }
            return true;
        }
        return false;
    }

    @Override
    public void execute(Facts facts) throws Exception {
        this.conditionalRule.execute(facts);
        for (Rule rule : this.sort(this.successfulEvaluations)) {
            rule.execute(facts);
        }
    }

    private Rule getRuleWithHighestPriority() {
        List<Rule> copy = this.sort(this.rules);
        Rule highest = copy.get(0);
        if (copy.size() > 1 && copy.get(1).getPriority() == highest.getPriority()) {
            throw new IllegalArgumentException("Only one rule can have highest priority");
        }
        return highest;
    }

    private List<Rule> sort(Set<Rule> rules) {
        return new ArrayList<Rule>(new TreeSet<Rule>(rules));
    }
}

