/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.core;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.ext.rules.api.Rule;
import org.rossonet.ext.rules.api.RuleListener;
import org.rossonet.ext.rules.api.Rules;
import org.rossonet.ext.rules.api.RulesEngineListener;
import org.rossonet.ext.rules.api.RulesEngineParameters;
import org.rossonet.ext.rules.core.AbstractRulesEngine;
import org.rossonet.ext.rules.core.DefaultRulesEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InferenceRulesEngine
extends AbstractRulesEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferenceRulesEngine.class);
    private final DefaultRulesEngine delegate;

    public InferenceRulesEngine() {
        this(new RulesEngineParameters());
    }

    public InferenceRulesEngine(RulesEngineParameters parameters) {
        super(parameters);
        this.delegate = new DefaultRulesEngine(parameters);
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        return this.delegate.check(rules, facts);
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        Set<Rule> selectedRules;
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        do {
            LOGGER.debug("Selecting candidate rules based on the following facts: {}", (Object)facts);
            selectedRules = this.selectCandidates(rules, facts);
            if (!selectedRules.isEmpty()) {
                this.delegate.fire(new Rules(selectedRules), facts);
                continue;
            }
            LOGGER.debug("No candidate rules found for facts: {}", (Object)facts);
        } while (!selectedRules.isEmpty());
    }

    @Override
    public void registerRuleListener(RuleListener ruleListener) {
        super.registerRuleListener(ruleListener);
        this.delegate.registerRuleListener(ruleListener);
    }

    @Override
    public void registerRuleListeners(List<RuleListener> ruleListeners) {
        super.registerRuleListeners(ruleListeners);
        this.delegate.registerRuleListeners(ruleListeners);
    }

    @Override
    public void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        super.registerRulesEngineListener(rulesEngineListener);
        this.delegate.registerRulesEngineListener(rulesEngineListener);
    }

    @Override
    public void registerRulesEngineListeners(List<RulesEngineListener> rulesEngineListeners) {
        super.registerRulesEngineListeners(rulesEngineListeners);
        this.delegate.registerRulesEngineListeners(rulesEngineListeners);
    }

    private Set<Rule> selectCandidates(Rules rules, Facts facts) {
        TreeSet<Rule> candidates = new TreeSet<Rule>();
        for (Rule rule : rules) {
            if (!rule.evaluate(facts)) continue;
            candidates.add(rule);
        }
        return candidates;
    }
}

