/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.rossonet.ext.rules.api.Fact;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.ext.rules.api.Rule;
import org.rossonet.ext.rules.api.Rules;
import org.rossonet.ext.rules.api.RulesEngineParameters;
import org.rossonet.ext.rules.core.AbstractRulesEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRulesEngine
extends AbstractRulesEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRulesEngine.class);

    public DefaultRulesEngine() {
    }

    public DefaultRulesEngine(RulesEngineParameters parameters) {
        super(parameters);
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> result = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return result;
    }

    private Map<Rule, Boolean> doCheck(Rules rules, Facts facts) {
        LOGGER.debug("Checking rules");
        HashMap<Rule, Boolean> result = new HashMap<Rule, Boolean>();
        for (Rule rule : rules) {
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            result.put(rule, rule.evaluate(facts));
        }
        return result;
    }

    void doFire(Rules rules, Facts facts) {
        if (rules.isEmpty()) {
            LOGGER.debug("No rules registered! Nothing to apply");
            return;
        }
        this.logEngineParameters();
        this.log(rules);
        this.log(facts);
        LOGGER.debug("Rules evaluation started");
        for (Rule rule : rules) {
            boolean evaluationResult;
            String name;
            block9: {
                name = rule.getName();
                int priority = rule.getPriority();
                if (priority > this.parameters.getPriorityThreshold()) {
                    LOGGER.debug("Rule priority threshold ({}) exceeded at rule '{}' with priority={}, next rules will be skipped", new Object[]{this.parameters.getPriorityThreshold(), name, priority});
                    break;
                }
                if (!this.shouldBeEvaluated(rule, facts)) {
                    LOGGER.debug("Rule '{}' has been skipped before being evaluated", (Object)name);
                    continue;
                }
                evaluationResult = false;
                try {
                    evaluationResult = rule.evaluate(facts);
                }
                catch (RuntimeException exception) {
                    LOGGER.error("Rule '" + name + "' evaluated with error", (Throwable)exception);
                    this.triggerListenersOnEvaluationError(rule, facts, exception);
                    if (!this.parameters.isSkipOnFirstNonTriggeredRule()) break block9;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                    break;
                }
            }
            if (evaluationResult) {
                LOGGER.debug("Rule '{}' triggered", (Object)name);
                this.triggerListenersAfterEvaluate(rule, facts, true);
                try {
                    this.triggerListenersBeforeExecute(rule, facts);
                    rule.execute(facts);
                    LOGGER.debug("Rule '{}' performed successfully", (Object)name);
                    this.triggerListenersOnSuccess(rule, facts);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstAppliedRule is set");
                }
                catch (Exception exception) {
                    LOGGER.error("Rule '" + name + "' performed with error", (Throwable)exception);
                    this.triggerListenersOnFailure(rule, exception, facts);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    LOGGER.debug("Next rules will be skipped since parameter skipOnFirstFailedRule is set");
                }
                break;
            }
            LOGGER.debug("Rule '{}' has been evaluated to false, it has not been executed", (Object)name);
            this.triggerListenersAfterEvaluate(rule, facts, false);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            LOGGER.debug("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            break;
        }
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    private void log(Facts facts) {
        LOGGER.debug("Known facts:");
        for (Fact<?> fact : facts) {
            LOGGER.debug("{}", fact);
        }
    }

    private void log(Rules rules) {
        LOGGER.debug("Registered rules:");
        for (Rule rule : rules) {
            LOGGER.debug("Rule { name = '{}', description = '{}', priority = '{}'}", new Object[]{rule.getName(), rule.getDescription(), rule.getPriority()});
        }
    }

    private void logEngineParameters() {
        LOGGER.debug("{}", (Object)this.parameters);
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.afterEvaluate(rule, facts, evaluationResult));
    }

    private void triggerListenersAfterRules(Rules rule, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.afterExecute(rule, facts));
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        return this.ruleListeners.stream().allMatch(ruleListener -> ruleListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.beforeExecute(rule, facts));
    }

    private void triggerListenersBeforeRules(Rules rule, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersOnEvaluationError(Rule rule, Facts facts, Exception exception) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onEvaluationError(rule, facts, exception));
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onFailure(rule, facts, exception));
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onSuccess(rule, facts));
    }
}

