/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.rossonet.ext.rules.api.Fact;

public class Facts
implements Iterable<Fact<?>> {
    private final Set<Fact<?>> facts = new HashSet();
    private boolean traceEnable;

    public <T> void add(Fact<T> fact) {
        Objects.requireNonNull(fact, "fact must not be null");
        Fact<?> retrievedFact = this.getFact(fact.getName());
        if (retrievedFact != null) {
            this.remove(retrievedFact);
        }
        this.facts.add(fact);
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Fact<?> fact : this.facts) {
            map.put(fact.getName(), fact.getValue());
        }
        return map;
    }

    public void clear() {
        this.facts.clear();
    }

    public <T> T get(String factName) {
        Objects.requireNonNull(factName, "fact name must not be null");
        Fact<?> fact = this.getFact(factName);
        if (fact != null) {
            return (T)fact.getValue();
        }
        return null;
    }

    public Fact<?> getFact(String factName) {
        Objects.requireNonNull(factName, "fact name must not be null");
        return this.facts.stream().filter(fact -> fact.getName().equals(factName)).findFirst().orElse(null);
    }

    public boolean isTraceEnable() {
        return this.traceEnable;
    }

    @Override
    public Iterator<Fact<?>> iterator() {
        return this.facts.iterator();
    }

    public <T> void put(String name, T value) {
        Objects.requireNonNull(name, "fact name must not be null");
        Objects.requireNonNull(value, "fact value must not be null");
        Fact<?> retrievedFact = this.getFact(name);
        if (retrievedFact != null) {
            this.remove(retrievedFact);
        }
        this.add(new Fact<T>(name, value));
    }

    public <T> void remove(Fact<T> fact) {
        Objects.requireNonNull(fact, "fact must not be null");
        this.facts.remove(fact);
    }

    public void remove(String factName) {
        Objects.requireNonNull(factName, "fact name must not be null");
        Fact<?> fact = this.getFact(factName);
        if (fact != null) {
            this.remove(fact);
        }
    }

    public void setTraceEnable(boolean traceEnable) {
        this.traceEnable = traceEnable;
    }

    public String toString() {
        Iterator<Fact<?>> iterator = this.facts.iterator();
        StringBuilder stringBuilder = new StringBuilder("[");
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

