/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.support.reader;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rossonet.ext.rules.support.RuleDefinition;
import org.rossonet.ext.rules.support.reader.RuleDefinitionReader;

public abstract class AbstractRuleDefinitionReader
implements RuleDefinitionReader {
    protected RuleDefinition createRuleDefinition(Map<String, Object> map) {
        RuleDefinition ruleDefinition = new RuleDefinition();
        String name = (String)map.get("name");
        ruleDefinition.setName(name != null ? name : "rule");
        String description = (String)map.get("description");
        ruleDefinition.setDescription(description != null ? description : "description");
        Integer priority = (Integer)map.get("priority");
        ruleDefinition.setPriority(priority != null ? priority : 0x7FFFFFFE);
        String compositeRuleType = (String)map.get("compositeRuleType");
        String condition = (String)map.get("condition");
        if (condition == null && compositeRuleType == null) {
            throw new IllegalArgumentException("The rule condition must be specified");
        }
        ruleDefinition.setCondition(condition);
        List actions = (List)map.get("actions");
        if ((actions == null || actions.isEmpty()) && compositeRuleType == null) {
            throw new IllegalArgumentException("The rule action(s) must be specified");
        }
        ruleDefinition.setActions(actions);
        List composingRules = (List)map.get("composingRules");
        if (composingRules != null && !composingRules.isEmpty() && compositeRuleType == null) {
            throw new IllegalArgumentException("Non-composite rules cannot have composing rules");
        }
        if ((composingRules == null || composingRules.isEmpty()) && compositeRuleType != null) {
            throw new IllegalArgumentException("Composite rules must have composing rules specified");
        }
        if (composingRules != null) {
            ArrayList<RuleDefinition> composingRuleDefinitions = new ArrayList<RuleDefinition>();
            for (Object rule : composingRules) {
                Map composingRuleMap = (Map)rule;
                composingRuleDefinitions.add(this.createRuleDefinition(composingRuleMap));
            }
            ruleDefinition.setComposingRules(composingRuleDefinitions);
            ruleDefinition.setCompositeRuleType(compositeRuleType);
        }
        return ruleDefinition;
    }

    protected abstract Iterable<Map<String, Object>> loadRules(Reader var1) throws Exception;

    @Override
    public List<RuleDefinition> read(Reader reader) throws Exception {
        ArrayList<RuleDefinition> ruleDefinitions = new ArrayList<RuleDefinition>();
        Iterable<Map<String, Object>> rules = this.loadRules(reader);
        for (Map<String, Object> rule : rules) {
            ruleDefinitions.add(this.createRuleDefinition(rule));
        }
        return ruleDefinitions;
    }
}

