/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.support;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.rossonet.ext.rules.api.Rule;
import org.rossonet.ext.rules.api.Rules;
import org.rossonet.ext.rules.support.RuleDefinition;
import org.rossonet.ext.rules.support.composite.ActivationRuleGroup;
import org.rossonet.ext.rules.support.composite.CompositeRule;
import org.rossonet.ext.rules.support.composite.ConditionalRuleGroup;
import org.rossonet.ext.rules.support.composite.UnitRuleGroup;
import org.rossonet.ext.rules.support.reader.RuleDefinitionReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRuleFactory.class);
    private static final List<String> ALLOWED_COMPOSITE_RULE_TYPES = Arrays.asList(UnitRuleGroup.class.getSimpleName(), ConditionalRuleGroup.class.getSimpleName(), ActivationRuleGroup.class.getSimpleName());

    protected Rule createCompositeRule(RuleDefinition ruleDefinition) {
        CompositeRule compositeRule;
        if (ruleDefinition.getCondition() != null) {
            LOGGER.warn("Condition '{}' in composite rule '{}' of type {} will be ignored.", new Object[]{ruleDefinition.getCondition(), ruleDefinition.getName(), ruleDefinition.getCompositeRuleType()});
        }
        if (ruleDefinition.getActions() != null && !ruleDefinition.getActions().isEmpty()) {
            LOGGER.warn("Actions '{}' in composite rule '{}' of type {} will be ignored.", new Object[]{ruleDefinition.getActions(), ruleDefinition.getName(), ruleDefinition.getCompositeRuleType()});
        }
        String name = ruleDefinition.getName();
        switch (ruleDefinition.getCompositeRuleType()) {
            case "UnitRuleGroup": {
                compositeRule = new UnitRuleGroup(name);
                break;
            }
            case "ActivationRuleGroup": {
                compositeRule = new ActivationRuleGroup(name);
                break;
            }
            case "ConditionalRuleGroup": {
                compositeRule = new ConditionalRuleGroup(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid composite rule type, must be one of " + ALLOWED_COMPOSITE_RULE_TYPES);
            }
        }
        compositeRule.setDescription(ruleDefinition.getDescription());
        compositeRule.setPriority(ruleDefinition.getPriority());
        for (RuleDefinition composingRuleDefinition : ruleDefinition.getComposingRules()) {
            compositeRule.addRule(this.createRule(composingRuleDefinition));
        }
        return compositeRule;
    }

    protected Rule createRule(RuleDefinition ruleDefinition) {
        if (ruleDefinition.isCompositeRule()) {
            return this.createCompositeRule(ruleDefinition);
        }
        return this.createSimpleRule(ruleDefinition);
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        Objects.requireNonNull(rulesDescriptor, "rulesDescriptor cannot be null");
        Rules rules = new Rules(new Rule[0]);
        List<RuleDefinition> ruleDefinitions = this.getRuleDefinitionReader().read(rulesDescriptor);
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            rules.register(this.createRule(ruleDefinition));
        }
        return rules;
    }

    protected abstract Rule createSimpleRule(RuleDefinition var1);

    protected abstract RuleDefinitionReader getRuleDefinitionReader();
}

