/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.brain.api.astrocyte.synapse;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.rossonet.brain.api.UniversallyUniqueObject;
import org.rossonet.brain.api.astrocyte.synapse.BrainThreadLogLine;
import org.rossonet.brain.api.astrocyte.synapse.Synapse;

public class BrainThread
extends Thread
implements UniversallyUniqueObject {
    private final Synapse synapse;
    private final List<BrainThreadLogLine> debugLines = new ArrayList<BrainThreadLogLine>();
    private final UUID uuid = UUID.randomUUID();

    public BrainThread(Synapse synapse) {
        this.synapse = synapse;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrainThread other = (BrainThread)obj;
        return Objects.equals(this.uuid, other.uuid);
    }

    public List<BrainThreadLogLine> getDebugLines() {
        return this.debugLines;
    }

    public Synapse getSynapse() {
        return this.synapse;
    }

    @Override
    public UUID getUniversallyUniqueIdentifier() {
        return this.uuid;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public void markStep(String message) {
        BrainThreadLogLine logLine = new BrainThreadLogLine();
        logLine.setMessage(message);
        logLine.setSynapse(this.synapse.getUniversallyUniqueIdentifier());
        logLine.setInstant(Instant.now());
        logLine.setThreadId(this.getId());
        logLine.setThreadName(this.getName());
        logLine.setThreadPriority(this.getPriority());
        logLine.setThreadStackTrace(this.getStackTrace());
        logLine.setThreadState(this.getState());
    }

    @Override
    public void run() {
        this.synapse.refuelling(this);
    }
}

