/*
 * The MIT License
 *
 *  Copyright (c) 2020, Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.rossonet.ext.rules.support;

import java.util.ArrayList;
import java.util.List;

import org.rossonet.ext.rules.api.Rule;

/**
 * Rule definition as defined in a rule descriptor. This class encapsulates the
 * static definition of a {@link Rule}.
 *
 * Rule definitions are produced by a {@code RuleDefinitionReader}s and consumed
 * by rule factories to create rules.
 *
 * @author Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 */
public class RuleDefinition {

	private String name = Rule.DEFAULT_NAME;
	private String description = Rule.DEFAULT_DESCRIPTION;
	private int priority = Rule.DEFAULT_PRIORITY;
	private String condition;
	private List<String> actions = new ArrayList<>();
	private List<RuleDefinition> composingRules = new ArrayList<>();
	private String compositeRuleType;

	public List<String> getActions() {
		return actions;
	}

	public List<RuleDefinition> getComposingRules() {
		return composingRules;
	}

	public String getCompositeRuleType() {
		return compositeRuleType;
	}

	public String getCondition() {
		return condition;
	}

	public String getDescription() {
		return description;
	}

	public String getName() {
		return name;
	}

	public int getPriority() {
		return priority;
	}

	public boolean isCompositeRule() {
		return !composingRules.isEmpty();
	}

	public void setActions(List<String> actions) {
		this.actions = actions;
	}

	public void setComposingRules(List<RuleDefinition> composingRuleDefinitions) {
		this.composingRules = composingRuleDefinitions;
	}

	public void setCompositeRuleType(String compositeRuleType) {
		this.compositeRuleType = compositeRuleType;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}
}
