/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemCommandHelper {
    private static final Pattern QUOTED_PATTERN = Pattern.compile("\"([^\"]*)\"|(\\S+)");

    public static void executeSystemCommandAndWait(File baseDirectory, String[] command, Consumer<String> consumer, int timeoutMilliSeconds) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        builder.directory(baseDirectory);
        Process process = builder.start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), process.getErrorStream(), consumer);
        Future<?> future = Executors.newSingleThreadExecutor().submit(streamGobbler);
        if (timeoutMilliSeconds != 0) {
            future.get(timeoutMilliSeconds, TimeUnit.MILLISECONDS);
        } else {
            future.get();
        }
    }

    private SystemCommandHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }

    public static class StreamGobbler
    implements Runnable {
        private final InputStream inputStream;
        private final Consumer<String> consumer;
        private final InputStream errorStream;

        public StreamGobbler(InputStream inputStream, InputStream errorStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.errorStream = errorStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
            new BufferedReader(new InputStreamReader(this.errorStream)).lines().forEach(this.consumer);
        }
    }

    public static class QuotedStringTokenizer {
        private final String line;
        private final List<String> tokens = new ArrayList<String>();
        private final Matcher matcher;
        private int index;

        public QuotedStringTokenizer(String line) {
            this.line = line.trim();
            this.matcher = QUOTED_PATTERN.matcher(line);
            while (!this.matcher.hitEnd()) {
                if (!this.matcher.find()) continue;
                String data = this.matcher.group(1) != null ? this.matcher.group(1) : this.matcher.group(2);
                this.tokens.add(data);
            }
        }

        public String getLine() {
            return this.line;
        }

        public List<String> getTokens() {
            return this.tokens;
        }

        public boolean hasMoreTokens() {
            return this.index < this.tokens.size();
        }

        public String nextToken() {
            String data = this.tokens.get(this.index);
            ++this.index;
            return data;
        }
    }
}

