/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rossonet.utils.ThreadHelper;

public final class NetworkHelper {
    private static final Long[] SUBNET_MASK = new Long[]{0xFFFF8000L, 0xFFFFC000L, 0xFFFFE000L, 0xFFFFF000L, 0xFFFFF800L, 0xFFFFFC00L, 0xFFFFFE00L, 0xFFFFFF00L, 0xFFFFFF80L, 0xFFFFFFC0L, 0xFFFFFFE0L, 0xFFFFFFF0L, 0xFFFFFFF8L, 0xFFFFFFFCL, 0xFFFFFFFEL, 0xFFFFFFFFL};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkLocalPortAvailable(int port) throws IOException {
        boolean portTaken = false;
        try (ServerSocket socket = null;){
            socket = new ServerSocket(port);
            socket.setReuseAddress(true);
        }
        return !portTaken;
    }

    public static boolean checkTcpPort(final SocketAddress inetSocketAddress, final int socketTimeoutSeconds) throws IOException {
        final AtomicBoolean ok = new AtomicBoolean(false);
        try {
            ThreadHelper.runWithTimeout(new Runnable(){

                @Override
                public void run() {
                    Socket s = null;
                    try {
                        s = new Socket();
                        s.setSoTimeout(socketTimeoutSeconds * 3);
                        s.connect(inetSocketAddress);
                        ok.set(true);
                    }
                    catch (Exception e) {
                        ok.set(false);
                    }
                    finally {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }, (long)socketTimeoutSeconds, TimeUnit.SECONDS);
            return ok.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int findAvailablePort(int faultPort) {
        try {
            ServerSocket socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (IOException ex) {
            return faultPort;
        }
    }

    public static List<String> getAllNetworkMacAddress() throws SocketException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            byte[] hardwareAddress = ni.getHardwareAddress();
            if (hardwareAddress == null) continue;
            CharSequence[] hexadecimalFormat = new String[hardwareAddress.length];
            for (int i = 0; i < hardwareAddress.length; ++i) {
                hexadecimalFormat[i] = String.format("%02X", hardwareAddress[i]);
            }
            result.add(String.join((CharSequence)"-", hexadecimalFormat));
        }
        return result;
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static Set<String> getHostnames(String address) throws UnknownHostException, SocketException {
        HashSet<String> hostnames = new HashSet<String>();
        InetAddress inetAddress = InetAddress.getByName(address);
        if (inetAddress.isAnyLocalAddress()) {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface ni : Collections.list(nis)) {
                Collections.list(ni.getInetAddresses()).forEach(ia -> {
                    if (ia instanceof Inet4Address) {
                        hostnames.add(ia.getHostName());
                        hostnames.add(ia.getHostAddress());
                        hostnames.add(ia.getCanonicalHostName());
                    }
                });
            }
        } else {
            hostnames.add(inetAddress.getHostName());
            hostnames.add(inetAddress.getHostAddress());
            hostnames.add(inetAddress.getCanonicalHostName());
        }
        return hostnames;
    }

    public static String getMacAddressAsString(String hostname) throws Exception {
        InetAddress ip = null;
        ip = InetAddress.getByName(hostname);
        NetworkInterface network = NetworkInterface.getByInetAddress(ip);
        if (network != null) {
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], ""));
            }
            return sb.toString().toLowerCase();
        }
        return null;
    }

    private static long ipAddressToLong(String ipAddress) {
        String[] s;
        if (ipAddress != null && (s = ipAddress.split("\\.")) != null && s.length == 4) {
            long result = 0L;
            for (int i = 3; i >= 0; --i) {
                try {
                    long n = Long.parseLong(s[3 - i]);
                    result |= n << i * 8;
                    continue;
                }
                catch (Exception ex) {
                    return -1L;
                }
            }
            return result;
        }
        return -1L;
    }

    public static boolean isValidIPAddress(String ip) {
        String zeroTo255 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String regex = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        Pattern p = Pattern.compile("(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])");
        if (ip == null) {
            return false;
        }
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    public static boolean isValidMacAddress(String macAddress) {
        String regex = "^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})|([0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}\\.[0-9a-fA-F]{4})$";
        Pattern p = Pattern.compile("^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})|([0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}\\.[0-9a-fA-F]{4})$");
        if (macAddress == null) {
            return false;
        }
        Matcher m = p.matcher(macAddress);
        return m.matches();
    }

    public static boolean isValidSubnetMask(String subnetMask) {
        long lSubnetMask;
        if (subnetMask != null && NetworkHelper.isValidIPAddress(subnetMask) && (lSubnetMask = NetworkHelper.ipAddressToLong(subnetMask)) > 0L) {
            return Arrays.asList(SUBNET_MASK).contains(lSubnetMask);
        }
        return false;
    }

    private NetworkHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

