/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;

public class SslHelper {
    public static String DEFAULT_CONTEXT_TLS_PROTOCOL = "TLSv1.2";
    public static String DEFAULT_SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final int SUBJECT_ALT_NAME_DNS_NAME = 2;
    public static final int SUBJECT_ALT_NAME_IP_ADDRESS = 7;
    public static final int SUBJECT_ALT_NAME_URI = 6;

    public static boolean checkSignatureWithPayload(PublicKey pubKey, PrivateKey privKey) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return SslHelper.checkSignatureWithPayload(pubKey, privKey, DEFAULT_SIGNATURE_ALGORITHM);
    }

    public static boolean checkSignatureWithPayload(PublicKey pubKey, PrivateKey privKey, String signatureAlgorithm) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        Signature sig = Signature.getInstance(signatureAlgorithm);
        sig.initSign(privKey);
        byte[] bytesCheck = "1234567890".getBytes();
        sig.update(bytesCheck);
        byte[] signature = sig.sign();
        sig.initVerify(pubKey);
        sig.update(bytesCheck);
        return sig.verify(signature);
    }

    public static PKCS10CertificationRequest createCertificationRequest(KeyPair keyPair, X509Certificate certificate) throws CertificateEncodingException, OperatorCreationException, CertificateParsingException, IOException {
        return SslHelper.createCertificationRequest(keyPair, certificate, DEFAULT_SIGNATURE_ALGORITHM);
    }

    public static PKCS10CertificationRequest createCertificationRequest(KeyPair keyPair, X509Certificate certificate, String signatureAlgorithm) throws OperatorCreationException, CertificateEncodingException, CertificateParsingException, IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)keyPair.getPublic().getEncoded()));
        PKCS10CertificationRequestBuilder p10Builder = new PKCS10CertificationRequestBuilder(new JcaX509CertificateHolder(certificate).getSubject(), subjectPublicKeyInfo);
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(signatureAlgorithm);
        ContentSigner signer = csBuilder.build(keyPair.getPrivate());
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        if (SslHelper.getSanUri(certificate).isPresent()) {
            generalNames.add(new GeneralName(6, SslHelper.getSanUri(certificate).get()));
        }
        generalNames.addAll(SslHelper.getSubjectAltNames(certificate));
        GeneralNames subjectAltNames = new GeneralNames(generalNames.toArray(new GeneralName[0]));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        PKCS10CertificationRequest certificateRequest = p10Builder.build(signer);
        return certificateRequest;
    }

    public static KeyStore createKeystore(String certificateAlias, X509Certificate certificate, String privateKeyAlias, PrivateKey privateKey, String keystorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        clientKeyStore.load(null, keystorePassword.toCharArray());
        clientKeyStore.setCertificateEntry(certificateAlias, certificate);
        clientKeyStore.setKeyEntry(privateKeyAlias, privateKey, keystorePassword.toCharArray(), new Certificate[]{certificate});
        return clientKeyStore;
    }

    public static KeyStore createKeystore(String caAlias, X509Certificate ca, String certificateAlias, X509Certificate certificate, String privateKeyAlias, PrivateKey privateKey, String keystorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        clientKeyStore.load(null, keystorePassword.toCharArray());
        clientKeyStore.setCertificateEntry(certificateAlias, certificate);
        clientKeyStore.setKeyEntry(privateKeyAlias, privateKey, keystorePassword.toCharArray(), new Certificate[]{certificate});
        return clientKeyStore;
    }

    public static KeyStore createKeyStore(String caAlias, Path caCrtFile, String certificateAlias, Path crtFile, String privateKeyAlias, Path keyFile, String keystorePassword) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
        PEMParser reader = new PEMParser((Reader)new FileReader(caCrtFile.toFile().getAbsolutePath()));
        X509CertificateHolder caCertHolder = (X509CertificateHolder)reader.readObject();
        reader.close();
        X509Certificate caCert = certificateConverter.getCertificate(caCertHolder);
        reader = new PEMParser((Reader)new FileReader(crtFile.toFile().getAbsolutePath()));
        X509CertificateHolder certHolder = (X509CertificateHolder)reader.readObject();
        reader.close();
        X509Certificate cert = certificateConverter.getCertificate(certHolder);
        reader = new PEMParser((Reader)new FileReader(keyFile.toFile().getAbsolutePath()));
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)reader.readObject();
        reader.close();
        KeyStore keyStore = SslHelper.createKeyStore(caAlias, caCert, certificateAlias, cert, privateKeyAlias, privateKeyInfo, keystorePassword);
        return keyStore;
    }

    public static KeyStore createKeyStore(String caAlias, String caCrtString, String certificateAlias, String certificateString, String privateKeyAlias, String privateKeyString, String keystorePassword) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Path caCrtFile = Files.createTempFile("caCrtFile", ".pem", new FileAttribute[0]);
        Path crtFile = Files.createTempFile("crtFile", ".pem", new FileAttribute[0]);
        Path keyFile = Files.createTempFile("keyFile", ".pem", new FileAttribute[0]);
        Files.write(caCrtFile, caCrtString.getBytes(), new OpenOption[0]);
        Files.write(crtFile, certificateString.getBytes(), new OpenOption[0]);
        Files.write(keyFile, privateKeyString.getBytes(), new OpenOption[0]);
        KeyStore keyStore = SslHelper.createKeyStore(caAlias, caCrtFile, certificateAlias, crtFile, privateKeyAlias, keyFile, keystorePassword);
        caCrtFile.toFile().delete();
        crtFile.toFile().delete();
        keyFile.toFile().delete();
        return keyStore;
    }

    public static TrustManagerFactory createKeyStore(String caAlias, X509Certificate caCert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        caKeyStore.load(null, null);
        caKeyStore.setCertificateEntry(caAlias, caCert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(caKeyStore);
        return trustManagerFactory;
    }

    public static KeyStore createKeyStore(String certificateAlias, X509Certificate certificate, String privateKeyAlias, PrivateKeyInfo privateKeyInfo, String keystorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
        PrivateKey key = keyConverter.getPrivateKey(privateKeyInfo);
        KeyStore clientKeyStore = SslHelper.createKeystore(certificateAlias, certificate, privateKeyAlias, key, keystorePassword);
        return clientKeyStore;
    }

    public static KeyStore createKeyStore(String caAlias, X509Certificate ca, String certificateAlias, X509Certificate certificate, String privateKeyAlias, PrivateKeyInfo privateKeyInfo, String keystorePassword) throws PEMException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
        PrivateKey key = keyConverter.getPrivateKey(privateKeyInfo);
        KeyStore clientKeyStore = SslHelper.createKeystore(caAlias, ca, certificateAlias, certificate, privateKeyAlias, key, keystorePassword);
        return clientKeyStore;
    }

    public static SSLContext createSSLContext(String caAlias, Path caCrtFile, String certificateAlias, Path crtFile, String privateKeyAlias, Path keyFile, String keystorePassword) throws KeyManagementException, UnrecoverableKeyException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return SslHelper.createSSLContext(keystorePassword, keyFile, keystorePassword, keyFile, keystorePassword, keyFile, keystorePassword, DEFAULT_CONTEXT_TLS_PROTOCOL);
    }

    public static SSLContext createSSLContext(String caAlias, Path caCrtFile, String certificateAlias, Path crtFile, String privateKeyAlias, Path keyFile, String keystorePassword, String sslContextProtocol) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
        PEMParser reader = new PEMParser((Reader)new FileReader(caCrtFile.toFile().getAbsolutePath()));
        X509CertificateHolder caCertHolder = (X509CertificateHolder)reader.readObject();
        reader.close();
        X509Certificate caCert = certificateConverter.getCertificate(caCertHolder);
        reader = new PEMParser((Reader)new FileReader(crtFile.toFile().getAbsolutePath()));
        X509CertificateHolder certHolder = (X509CertificateHolder)reader.readObject();
        reader.close();
        X509Certificate cert = certificateConverter.getCertificate(certHolder);
        reader = new PEMParser((Reader)new FileReader(keyFile.toFile().getAbsolutePath()));
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)reader.readObject();
        reader.close();
        KeyStore clientKeyStore = SslHelper.createKeyStore(certificateAlias, cert, privateKeyAlias, privateKeyInfo, keystorePassword);
        TrustManagerFactory trustManagerFactory = SslHelper.createKeyStore(caAlias, caCert);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(clientKeyStore, keystorePassword.toCharArray());
        SSLContext context = SSLContext.getInstance(sslContextProtocol);
        context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return context;
    }

    public static SSLContext createSSLContext(String caAlias, String caCrtString, String certificateAlias, String certificateString, String privateKeyAlias, String privateKeyString, String keystorePassword) throws IOException, KeyManagementException, UnrecoverableKeyException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Path caCrtFile = Files.createTempFile("caCrtFile", ".pem", new FileAttribute[0]);
        Path crtFile = Files.createTempFile("crtFile", ".pem", new FileAttribute[0]);
        Path keyFile = Files.createTempFile("keyFile", ".pem", new FileAttribute[0]);
        Files.write(caCrtFile, caCrtString.getBytes(), new OpenOption[0]);
        Files.write(crtFile, certificateString.getBytes(), new OpenOption[0]);
        Files.write(keyFile, privateKeyString.getBytes(), new OpenOption[0]);
        SSLContext sslContext = SslHelper.createSSLContext(caAlias, caCrtFile, certificateAlias, crtFile, privateKeyAlias, keyFile, keystorePassword);
        caCrtFile.toFile().delete();
        crtFile.toFile().delete();
        keyFile.toFile().delete();
        return sslContext;
    }

    public static String getDefaultCharSet() {
        OutputStreamWriter writer = new OutputStreamWriter(new ByteArrayOutputStream());
        String enc = writer.getEncoding();
        return enc;
    }

    public static List<String> getSanDnsNames(X509Certificate certificate) {
        List<Object> values = SslHelper.getSubjectAltNameField(certificate, 2);
        return values.stream().filter(v -> v instanceof String).map(String.class::cast).collect(Collectors.toList());
    }

    public static List<String> getSanIpAddresses(X509Certificate certificate) {
        List<Object> values = SslHelper.getSubjectAltNameField(certificate, 7);
        return values.stream().filter(v -> v instanceof String).map(String.class::cast).collect(Collectors.toList());
    }

    public static Optional<String> getSanUri(X509Certificate certificate) {
        List<Object> values = SslHelper.getSubjectAltNameField(certificate, 6);
        return values.stream().filter(v -> v instanceof String).map(String.class::cast).findFirst();
    }

    public static List<Object> getSubjectAltNameField(X509Certificate certificate, int field) {
        try {
            ArrayList<Object> values = new ArrayList<Object>();
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
            for (List<?> idAndValue : subjectAltNames) {
                Object value;
                if (idAndValue == null || idAndValue.size() != 2 || !idAndValue.get(0).equals(field) || (value = idAndValue.get(1)) == null) continue;
                values.add(value);
            }
            return values;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    public static List<GeneralName> getSubjectAltNames(X509Certificate certificate) {
        try {
            ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
            for (List<?> idAndValue : subjectAltNames) {
                if (idAndValue == null || idAndValue.size() != 2) continue;
                Object id = idAndValue.get(0);
                String value = Objects.toString(idAndValue.get(1));
                if (Objects.equals(id, 2)) {
                    generalNames.add(new GeneralName(2, value));
                    continue;
                }
                if (Objects.equals(id, 7)) {
                    generalNames.add(new GeneralName(7, value));
                    continue;
                }
                if (!Objects.equals(id, 6)) continue;
                generalNames.add(new GeneralName(6, value));
            }
            return generalNames;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    public static X509Certificate signCertificate(PKCS10CertificationRequest certificationRequest, X509Certificate caCertificate, PrivateKey caPrivateKey, int validity) throws IOException, OperatorCreationException, CertificateException {
        return SslHelper.signCertificate(certificationRequest, caCertificate, caPrivateKey, validity, DEFAULT_SIGNATURE_ALGORITHM);
    }

    public static X509Certificate signCertificate(PKCS10CertificationRequest certificationRequest, X509Certificate caCertificate, PrivateKey caPrivateKey, int validity, String signatureAlgorithm) throws IOException, OperatorCreationException, CertificateException {
        StringBuilder attributes = new StringBuilder();
        for (Attribute attribute : certificationRequest.getAttributes()) {
            attributes.append(attribute.getAttrValues().toString());
        }
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        X509v3CertificateBuilder certificateGenerator = new X509v3CertificateBuilder(new X509CertificateHolder(caCertificate.getEncoded()).getSubject(), new BigInteger(64, new SecureRandom()), Date.from(LocalDateTime.now().toInstant(ZoneOffset.UTC).minus(1L, ChronoUnit.DAYS)), Date.from(LocalDateTime.now().plusDays(validity).toInstant(ZoneOffset.UTC)), certificationRequest.getSubject(), SubjectPublicKeyInfo.getInstance((Object)certificationRequest.getSubjectPublicKeyInfo()));
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(PrivateKeyFactory.createKey((byte[])caPrivateKey.getEncoded()));
        X509CertificateHolder holder = certificateGenerator.build(sigGen);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(holder.toASN1Structure().getEncoded()));
        return certificate;
    }

    private SslHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }

    public <OBJECT_TYPE> String encodeInPemFormat(OBJECT_TYPE data) throws IOException {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        pemWriter.writeObject(data);
        pemWriter.flush();
        pemWriter.close();
        return writer.toString();
    }
}

