/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.utils.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class PriorityDeque<E>
extends AbstractQueue<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = -5410497035045299533L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private transient Object[] deque;
    private final Comparator<? super E> comparator;
    private int size = 0;
    private transient int modCount = 0;

    private static <T> void bubbleUp(Object[] deque, int size, int index) {
        int parentIndex = PriorityDeque.getParentIndex(index);
        if (Level.MIN.equals((Object)PriorityDeque.getLevel(size, index))) {
            if (index > 0 && ((Comparable)deque[index]).compareTo(deque[parentIndex]) > 0) {
                PriorityDeque.swap(deque, size, index, parentIndex);
                PriorityDeque.bubbleUpMax(deque, size, parentIndex);
            } else {
                PriorityDeque.bubbleUpMin(deque, size, index);
            }
        } else if (index > 0 && ((Comparable)deque[index]).compareTo(deque[parentIndex]) < 1) {
            PriorityDeque.swap(deque, size, index, parentIndex);
            PriorityDeque.bubbleUpMin(deque, size, parentIndex);
        } else {
            PriorityDeque.bubbleUpMax(deque, size, index);
        }
    }

    private static <T> void bubbleUpComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        int parentIndex = PriorityDeque.getParentIndex(index);
        if (Level.MIN.equals((Object)PriorityDeque.getLevel(size, index))) {
            if (index > 0 && comparator.compare(deque[index], deque[parentIndex]) > 0) {
                PriorityDeque.swap(deque, size, index, parentIndex);
                PriorityDeque.bubbleUpMaxComparator(deque, size, parentIndex, comparator);
            } else {
                PriorityDeque.bubbleUpMinComparator(deque, size, index, comparator);
            }
        } else if (index > 0 && comparator.compare(deque[index], deque[parentIndex]) < 1) {
            PriorityDeque.swap(deque, size, index, parentIndex);
            PriorityDeque.bubbleUpMinComparator(deque, size, parentIndex, comparator);
        } else {
            PriorityDeque.bubbleUpMaxComparator(deque, size, index, comparator);
        }
    }

    private static <T> void bubbleUpMax(Object[] deque, int size, int index) {
        int grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && ((Comparable)deque[index]).compareTo(deque[grandParentIndex]) > 0) {
            PriorityDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(grandParentIndex));
        }
    }

    private static <T> void bubbleUpMaxComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        int grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && comparator.compare(deque[index], deque[grandParentIndex]) > 0) {
            PriorityDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(grandParentIndex));
        }
    }

    private static <T> void bubbleUpMin(Object[] deque, int size, int index) {
        int grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && ((Comparable)deque[index]).compareTo(deque[grandParentIndex]) < 1) {
            PriorityDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(grandParentIndex));
        }
    }

    private static <T> void bubbleUpMinComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        int grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && comparator.compare(deque[index], deque[grandParentIndex]) < 1) {
            PriorityDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityDeque.getParentIndex(PriorityDeque.getParentIndex(grandParentIndex));
        }
    }

    private static Object[][] getChildren(Object[] deque, int size, int index) {
        Object[][] children = new Object[2][2];
        int leftChildIndex = PriorityDeque.getLeftChildIndex(index);
        int rightChildIndex = PriorityDeque.getRightChildIndex(index);
        if (PriorityDeque.isLeftChildPresent(deque, size, index)) {
            children[0][0] = deque[leftChildIndex];
            children[1][0] = leftChildIndex;
        }
        if (PriorityDeque.isRightChildPresent(deque, size, index)) {
            children[0][1] = deque[rightChildIndex];
            children[1][1] = rightChildIndex;
        }
        return children;
    }

    private static Object[][] getGrandChildren(Object[] deque, int size, int index) {
        Object[][] grandChildren = new Object[2][4];
        int leftChildIndex = PriorityDeque.getLeftChildIndex(index);
        int rightChildIndex = PriorityDeque.getRightChildIndex(index);
        int gcll = PriorityDeque.getLeftChildIndex(leftChildIndex);
        int gclr = PriorityDeque.getRightChildIndex(leftChildIndex);
        int gcrl = PriorityDeque.getLeftChildIndex(rightChildIndex);
        int gcrr = PriorityDeque.getRightChildIndex(rightChildIndex);
        if (PriorityDeque.isLeftChildPresent(deque, size, index)) {
            if (PriorityDeque.isLeftChildPresent(deque, size, leftChildIndex)) {
                grandChildren[0][0] = deque[gcll];
                grandChildren[1][0] = gcll;
            }
            if (PriorityDeque.isRightChildPresent(deque, size, leftChildIndex)) {
                grandChildren[0][1] = deque[gclr];
                grandChildren[1][1] = gclr;
            }
        }
        if (PriorityDeque.isRightChildPresent(deque, size, index)) {
            if (PriorityDeque.isLeftChildPresent(deque, size, rightChildIndex)) {
                grandChildren[0][2] = deque[gcrl];
                grandChildren[1][2] = gcrl;
            }
            if (PriorityDeque.isRightChildPresent(deque, size, rightChildIndex)) {
                grandChildren[0][3] = deque[gcrr];
                grandChildren[1][3] = gcrr;
            }
        }
        return grandChildren;
    }

    private static int getLeftChildIndex(int parentIndex) {
        return 2 * parentIndex + 1;
    }

    private static Level getLevel(int size, int index) {
        int depth;
        int noOfElements = 0;
        for (depth = 0; depth < size && index - (noOfElements = (int)((double)noOfElements + Math.pow(2.0, depth))) >= 0; ++depth) {
        }
        return depth % 2 == 0 ? Level.MIN : Level.MAX;
    }

    private static int getParentIndex(int childIndex) {
        return childIndex > 0 ? (childIndex - 1) / 2 : -1;
    }

    private static int getRightChildIndex(int parentIndex) {
        return 2 * (parentIndex + 1);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    private static int indexOf(Object o, Object[] deque, int size) {
        if (o != null) {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(deque[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static <T> int indexOfLargerChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] children = PriorityDeque.getChildren(deque, size, index);
        if (children[0][0] == null && children[0][1] == null) {
            return -1;
        }
        if (children[0][0] == null) {
            return (Integer)children[1][1];
        }
        if (children[0][1] == null) {
            return (Integer)children[1][0];
        }
        if (comparator == null) {
            if (((Comparable)children[0][0]).compareTo(children[0][1]) > 0) {
                return (Integer)children[1][0];
            }
            return (Integer)children[1][1];
        }
        if (comparator.compare(children[0][0], children[0][1]) > 0) {
            return (Integer)children[1][0];
        }
        return (Integer)children[1][1];
    }

    private static <T> int indexOfLargestGrandChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] grandChildren = PriorityDeque.getGrandChildren(deque, size, index);
        Object largest = grandChildren[0][0];
        Object largestIndex = grandChildren[1][0];
        for (int count = 1; count < grandChildren[0].length; ++count) {
            if (largest == null) {
                largest = grandChildren[0][count];
                largestIndex = grandChildren[1][count];
                continue;
            }
            if (grandChildren[0][count] == null) continue;
            if (comparator == null) {
                if (((Comparable)largest).compareTo(grandChildren[0][count]) >= 0) continue;
                largest = grandChildren[0][count];
                largestIndex = grandChildren[1][count];
                continue;
            }
            if (comparator.compare(largest, grandChildren[0][count]) >= 0) continue;
            largest = grandChildren[0][count];
            largestIndex = grandChildren[1][count];
        }
        return largestIndex != null ? (Integer)largestIndex : -1;
    }

    private static <T> int indexOfSmallerChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] children = PriorityDeque.getChildren(deque, size, index);
        if (children[0][0] == null && children[0][1] == null) {
            return -1;
        }
        if (children[0][0] == null) {
            return (Integer)children[1][1];
        }
        if (children[0][1] == null) {
            return (Integer)children[1][0];
        }
        if (comparator == null) {
            if (((Comparable)children[0][0]).compareTo(children[0][1]) < 1) {
                return (Integer)children[1][0];
            }
            return (Integer)children[1][1];
        }
        if (comparator.compare(children[0][0], children[0][1]) < 1) {
            return (Integer)children[1][0];
        }
        return (Integer)children[1][1];
    }

    private static <T> int indexOfSmallestGrandChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] grandChildren = PriorityDeque.getGrandChildren(deque, size, index);
        Object smallest = grandChildren[0][0];
        Object smallestIndex = grandChildren[1][0];
        for (int count = 1; count < grandChildren[0].length; ++count) {
            if (smallest == null) {
                smallest = grandChildren[0][count];
                smallestIndex = grandChildren[1][count];
                continue;
            }
            if (grandChildren[0][count] == null) continue;
            if (comparator == null) {
                if (((Comparable)smallest).compareTo(grandChildren[0][count]) <= 0) continue;
                smallest = grandChildren[0][count];
                smallestIndex = grandChildren[1][count];
                continue;
            }
            if (comparator.compare(smallest, grandChildren[0][count]) <= 0) continue;
            smallest = grandChildren[0][count];
            smallestIndex = grandChildren[1][count];
        }
        return smallestIndex != null ? (Integer)smallestIndex : -1;
    }

    private static boolean isLeftChildPresent(Object[] deque, int size, int index) {
        int leftChildIndex = PriorityDeque.getLeftChildIndex(index);
        return leftChildIndex < size && deque[leftChildIndex] != null;
    }

    private static boolean isRightChildPresent(Object[] deque, int size, int index) {
        int rightChildIndex = PriorityDeque.getRightChildIndex(index);
        return rightChildIndex < size && deque[rightChildIndex] != null;
    }

    private static void swap(Object[] deque, int size, int index1, int index2) {
        if (index1 < 0 || index1 >= size || index2 < 0 || index2 >= size) {
            throw new IllegalArgumentException();
        }
        Object temp = deque[index1];
        deque[index1] = deque[index2];
        deque[index2] = temp;
        temp = null;
    }

    private static <T> void trickleDown(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        if (Level.MIN.equals((Object)PriorityDeque.getLevel(size, index))) {
            if (comparator == null) {
                PriorityDeque.trickleDownMin(deque, size, index);
            } else {
                PriorityDeque.trickleDownMinComparator(deque, size, index, comparator);
            }
        } else if (comparator == null) {
            PriorityDeque.trickleDownMax(deque, size, index);
        } else {
            PriorityDeque.trickleDownMaxComparator(deque, size, index, comparator);
        }
    }

    private static <T> void trickleDownMax(Object[] deque, int size, int index) {
        while (index >= 0 && (PriorityDeque.isLeftChildPresent(deque, size, index) || PriorityDeque.isRightChildPresent(deque, size, index))) {
            int iLargestGc = PriorityDeque.indexOfLargestGrandChild(deque, size, index, null);
            int iLargestCh = PriorityDeque.indexOfLargerChild(deque, size, index, null);
            if (iLargestGc > 0 && ((Comparable)deque[iLargestGc]).compareTo(deque[index]) > 0) {
                PriorityDeque.swap(deque, size, index, iLargestGc);
                int parent = PriorityDeque.getParentIndex(iLargestGc);
                if (((Comparable)deque[iLargestGc]).compareTo(deque[parent]) < 1) {
                    PriorityDeque.swap(deque, size, iLargestGc, parent);
                }
            }
            if (iLargestCh > 0 && ((Comparable)deque[iLargestCh]).compareTo(deque[index]) > 0) {
                PriorityDeque.swap(deque, size, index, iLargestCh);
            }
            index = iLargestGc;
        }
    }

    private static <T> void trickleDownMaxComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        while (index >= 0 && (PriorityDeque.isLeftChildPresent(deque, size, index) || PriorityDeque.isRightChildPresent(deque, size, index))) {
            int iLargestGc = PriorityDeque.indexOfLargestGrandChild(deque, size, index, comparator);
            int iLargestCh = PriorityDeque.indexOfLargerChild(deque, size, index, comparator);
            if (iLargestGc > 0 && comparator.compare(deque[iLargestGc], deque[index]) > 0) {
                PriorityDeque.swap(deque, size, index, iLargestGc);
                int parent = PriorityDeque.getParentIndex(iLargestGc);
                if (comparator.compare(deque[iLargestGc], deque[parent]) < 1) {
                    PriorityDeque.swap(deque, size, iLargestGc, parent);
                }
            }
            if (iLargestCh > 0 && comparator.compare(deque[iLargestCh], deque[index]) > 0) {
                PriorityDeque.swap(deque, size, index, iLargestCh);
            }
            index = iLargestGc;
        }
    }

    private static <T> void trickleDownMin(Object[] deque, int size, int index) {
        while (index >= 0 && (PriorityDeque.isLeftChildPresent(deque, size, index) || PriorityDeque.isRightChildPresent(deque, size, index))) {
            int iSmallestGc = PriorityDeque.indexOfSmallestGrandChild(deque, size, index, null);
            int iSmallestCh = PriorityDeque.indexOfSmallerChild(deque, size, index, null);
            if (iSmallestGc > 0 && ((Comparable)deque[iSmallestGc]).compareTo(deque[index]) < 1) {
                PriorityDeque.swap(deque, size, index, iSmallestGc);
                int parent = PriorityDeque.getParentIndex(iSmallestGc);
                if (((Comparable)deque[iSmallestGc]).compareTo(deque[parent]) > 0) {
                    PriorityDeque.swap(deque, size, iSmallestGc, parent);
                }
            }
            if (iSmallestCh > 0 && ((Comparable)deque[iSmallestCh]).compareTo(deque[index]) < 1) {
                PriorityDeque.swap(deque, size, index, iSmallestCh);
            }
            index = iSmallestGc;
        }
    }

    private static <T> void trickleDownMinComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        while (index >= 0 && (PriorityDeque.isLeftChildPresent(deque, size, index) || PriorityDeque.isRightChildPresent(deque, size, index))) {
            int iSmallestGc = PriorityDeque.indexOfSmallestGrandChild(deque, size, index, comparator);
            int iSmallestCh = PriorityDeque.indexOfSmallerChild(deque, size, index, comparator);
            if (iSmallestGc > 0 && comparator.compare(deque[iSmallestGc], deque[index]) < 1) {
                PriorityDeque.swap(deque, size, index, iSmallestGc);
                int parent = PriorityDeque.getParentIndex(iSmallestGc);
                if (comparator.compare(deque[iSmallestGc], deque[parent]) > 0) {
                    PriorityDeque.swap(deque, size, iSmallestGc, parent);
                }
            }
            if (iSmallestCh > 0 && comparator.compare(deque[iSmallestCh], deque[index]) < 1) {
                PriorityDeque.swap(deque, size, index, iSmallestCh);
            }
            index = iSmallestGc;
        }
    }

    public PriorityDeque() {
        this(11, null);
    }

    public PriorityDeque(Collection<? extends E> c) {
        if (c instanceof SortedSet) {
            SortedSet ss = (SortedSet)c;
            this.comparator = ss.comparator();
            this.addAll(ss);
        } else if (c instanceof PriorityDeque) {
            PriorityDeque pq = (PriorityDeque)c;
            this.comparator = pq.comparator();
            this.initFromPriorityDeque(pq);
        } else {
            this.comparator = null;
            this.addAll(c);
        }
    }

    public PriorityDeque(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityDeque(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.deque = new Object[initialCapacity];
        this.comparator = comparator;
    }

    public PriorityDeque(PriorityDeque<? extends E> c) {
        this.comparator = c.comparator();
        this.initFromPriorityDeque(c);
    }

    public PriorityDeque(SortedSet<? extends E> c) {
        this.comparator = c.comparator();
        this.addAll(c);
    }

    @Override
    public void addFirst(E e) {
        this.add(e);
    }

    @Override
    public void addLast(E e) {
        this.add(e);
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.deque[i] = null;
        }
        this.size = 0;
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public boolean contains(Object o) {
        return PriorityDeque.indexOf(o, this.deque, this.size) != -1;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new Itr(true);
    }

    @Override
    public E getFirst() {
        E x = this.peekFirst();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E getLast() {
        E x = this.peekLast();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    private void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + ((oldCapacity = this.deque.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = PriorityDeque.hugeCapacity(minCapacity);
        }
        this.deque = Arrays.copyOf(this.deque, newCapacity);
    }

    private void initFromPriorityDeque(PriorityDeque<? extends E> c) {
        if (c.getClass() == PriorityDeque.class) {
            this.deque = c.toArray();
            this.size = c.size();
        } else {
            this.addAll(c);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(false);
    }

    @Override
    public boolean offer(E element) {
        ++this.modCount;
        if (element == null) {
            throw new NullPointerException();
        }
        int index = this.size;
        if (index >= this.deque.length) {
            this.grow(index + 1);
        }
        this.size = index + 1;
        if (index == 0) {
            this.deque[0] = element;
        } else {
            this.deque[index] = element;
            if (this.comparator == null) {
                PriorityDeque.bubbleUp(this.deque, this.size, index);
            } else {
                PriorityDeque.bubbleUpComparator(this.deque, this.size, index, this.comparator);
            }
        }
        return true;
    }

    @Override
    public boolean offerFirst(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.offer(e);
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        if (this.size > 0) {
            return (E)this.deque[0];
        }
        return null;
    }

    @Override
    public E peekLast() {
        Object result = null;
        if (this.size > 0) {
            int indexMax = PriorityDeque.indexOfLargerChild(this.deque, this.size, 0, this.comparator);
            int indexPeek = indexMax > 0 ? indexMax : 0;
            result = this.deque[indexPeek];
        }
        return (E)result;
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollFirst() {
        ++this.modCount;
        return this.removeAt(0);
    }

    @Override
    public E pollLast() {
        ++this.modCount;
        int indexMax = PriorityDeque.indexOfLargerChild(this.deque, this.size, 0, this.comparator);
        int indexRemove = indexMax > 0 ? indexMax : 0;
        return this.removeAt(indexRemove);
    }

    @Override
    public E pop() {
        throw new UnsupportedOperationException("Cannot use a priority deque as a stack");
    }

    @Override
    public void push(E e) {
        throw new UnsupportedOperationException("Cannot use a priority deque as a stack");
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        s.readInt();
        this.deque = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.deque[i] = s.readObject();
        }
    }

    @Override
    public E remove() {
        E x = this.poll();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean remove(Object o) {
        int i = PriorityDeque.indexOf(o, this.deque, this.size);
        if (i == -1) {
            return false;
        }
        ++this.modCount;
        this.removeAt(i);
        return true;
    }

    private E removeAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException();
        }
        if (this.size > 0) {
            Object obj = this.deque[index];
            --this.size;
            if (this.size > 0) {
                this.deque[index] = this.deque[this.size];
                this.deque[this.size] = null;
                PriorityDeque.trickleDown(this.deque, this.size, index, this.comparator);
            } else {
                this.deque[index] = null;
            }
            return (E)obj;
        }
        return null;
    }

    private boolean removeAtIter(int index, boolean desc) {
        if (!desc) {
            if (index < this.size - 1) {
                Object moved = this.deque[this.size - 1];
                ++this.modCount;
                this.removeAt(index);
                if (moved == this.deque[index]) {
                    return true;
                }
            }
        } else if (index >= 0) {
            this.removeAt(index);
        }
        return false;
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        int firstIndex = -1;
        for (int count = 0; count < this.size; ++count) {
            if (!this.deque[count].equals(o)) continue;
            firstIndex = count;
            break;
        }
        if (firstIndex >= 0) {
            ++this.modCount;
            this.removeAt(firstIndex);
            return true;
        }
        return false;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        int lastIndex = -1;
        for (int count = this.size - 1; count >= 0; --count) {
            if (!this.deque[count].equals(o)) continue;
            lastIndex = count;
            break;
        }
        if (lastIndex >= 0) {
            ++this.modCount;
            this.removeAt(lastIndex);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.deque, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.deque, this.size, a.getClass());
        }
        System.arraycopy(this.deque, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(Math.max(2, this.size + 1));
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.deque[i]);
        }
    }

    private static enum Level {
        MIN,
        MAX;

    }

    private final class Itr
    implements Iterator<E> {
        private boolean desc = false;
        private int cursor = 0;
        private int lastRet = -1;
        private int expectedModCount;

        private Itr(boolean desc) {
            this.expectedModCount = PriorityDeque.this.modCount;
            this.desc = desc;
            if (desc) {
                this.cursor = PriorityDeque.this.size - 1;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.desc && this.cursor < PriorityDeque.this.size || this.desc && this.cursor >= 0;
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityDeque.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.desc) {
                return this.nextAsc();
            }
            if (this.desc) {
                return this.nextDesc();
            }
            throw new NoSuchElementException();
        }

        private E nextAsc() {
            if (this.cursor < PriorityDeque.this.size) {
                this.lastRet = this.cursor++;
                return PriorityDeque.this.deque[this.lastRet];
            }
            throw new NoSuchElementException();
        }

        private E nextDesc() {
            if (this.cursor >= 0) {
                this.lastRet = this.cursor--;
                return PriorityDeque.this.deque[this.lastRet];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityDeque.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                boolean decrementCounter = PriorityDeque.this.removeAtIter(this.lastRet, this.desc);
                this.lastRet = -1;
                if (decrementCounter) {
                    --this.cursor;
                }
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityDeque.this.modCount;
        }
    }
}

