/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.mvel;

import java.io.Serializable;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.rossonet.ext.rules.api.Action;
import org.rossonet.ext.rules.api.Facts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELAction
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(MVELAction.class);
    private final String expression;
    private final Serializable compiledExpression;

    public MVELAction(String expression) {
        this.expression = expression;
        this.compiledExpression = MVEL.compileExpression((String)expression);
    }

    public MVELAction(String expression, ParserContext parserContext) {
        this.expression = expression;
        this.compiledExpression = MVEL.compileExpression((String)expression, (ParserContext)parserContext);
    }

    @Override
    public void execute(Facts facts) {
        try {
            MVEL.executeExpression((Object)this.compiledExpression, facts.asMap());
        }
        catch (Exception e) {
            LOGGER.error("Unable to evaluate expression: '" + this.expression + "' on facts: " + facts, (Throwable)e);
            throw e;
        }
    }
}

