/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.jexl;

import java.util.Objects;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.rossonet.ext.rules.api.Condition;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.ext.rules.jexl.JexlRule;

public class JexlCondition
implements Condition {
    private final JexlScript compiledScript;

    public JexlCondition(String expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        this.compiledScript = JexlRule.DEFAULT_JEXL.createScript(expression);
    }

    public JexlCondition(String expression, JexlEngine jexl) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Objects.requireNonNull(jexl, "jexl cannot be null");
        this.compiledScript = jexl.createScript(expression);
    }

    @Override
    public boolean evaluate(Facts facts) {
        Objects.requireNonNull(facts, "facts cannot be null");
        MapContext ctx = new MapContext(facts.asMap());
        return (Boolean)this.compiledScript.execute((JexlContext)ctx);
    }
}

