/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class SslHelper {
    public static KeyStore createKeystore(String password, X509Certificate cert, PrivateKey key) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        clientKeyStore.load(null, null);
        clientKeyStore.setCertificateEntry("certificate", cert);
        clientKeyStore.setKeyEntry("private-key", key, password.toCharArray(), new Certificate[]{cert});
        return clientKeyStore;
    }

    public static String getDefaultCharSet() {
        OutputStreamWriter writer = new OutputStreamWriter(new ByteArrayOutputStream());
        String enc = writer.getEncoding();
        return enc;
    }

    public static SSLContext getSSLContext(Path caCrtFile, Path crtFile, Path keyFile, String password) throws Exception {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            PEMParser reader = new PEMParser((Reader)new FileReader(caCrtFile.toFile().getAbsolutePath()));
            X509CertificateHolder caCertHolder = (X509CertificateHolder)reader.readObject();
            reader.close();
            X509Certificate caCert = certificateConverter.getCertificate(caCertHolder);
            reader = new PEMParser((Reader)new FileReader(crtFile.toFile().getAbsolutePath()));
            X509CertificateHolder certHolder = (X509CertificateHolder)reader.readObject();
            reader.close();
            X509Certificate cert = certificateConverter.getCertificate(certHolder);
            reader = new PEMParser((Reader)new FileReader(keyFile.toFile().getAbsolutePath()));
            Object keyObject = reader.readObject();
            reader.close();
            JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
            PrivateKey key = keyConverter.getPrivateKey((PrivateKeyInfo)keyObject);
            KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            caKeyStore.load(null, null);
            caKeyStore.setCertificateEntry("ca-certificate", caCert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            KeyStore clientKeyStore = SslHelper.createKeystore(password, cert, key);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientKeyStore, password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return context;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static SSLContext getSSLContext(String caCrtString, String certificateString, String privateKeyString, String keystorePassword) throws Exception {
        Path caCrtFile = Files.createTempFile("caCrtFile", ".pem", new FileAttribute[0]);
        Path crtFile = Files.createTempFile("crtFile", ".pem", new FileAttribute[0]);
        Path keyFile = Files.createTempFile("keyFile", ".pem", new FileAttribute[0]);
        Files.write(caCrtFile, caCrtString.getBytes(), new OpenOption[0]);
        Files.write(crtFile, certificateString.getBytes(), new OpenOption[0]);
        Files.write(keyFile, privateKeyString.getBytes(), new OpenOption[0]);
        SSLContext sslContext = SslHelper.getSSLContext(caCrtFile, crtFile, keyFile, keystorePassword);
        caCrtFile.toFile().delete();
        crtFile.toFile().delete();
        keyFile.toFile().delete();
        return sslContext;
    }

    private SslHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

