/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.jexl;

import java.io.Reader;
import java.util.List;
import java.util.Objects;
import org.apache.commons.jexl3.JexlEngine;
import org.rossonet.ext.rules.api.Rule;
import org.rossonet.ext.rules.api.Rules;
import org.rossonet.ext.rules.jexl.JexlRule;
import org.rossonet.ext.rules.support.AbstractRuleFactory;
import org.rossonet.ext.rules.support.RuleDefinition;
import org.rossonet.ext.rules.support.reader.RuleDefinitionReader;

public class JexlRuleFactory
extends AbstractRuleFactory {
    private final RuleDefinitionReader reader;
    private final JexlEngine jexl;

    public JexlRuleFactory(RuleDefinitionReader reader) {
        this(reader, JexlRule.DEFAULT_JEXL);
    }

    public JexlRuleFactory(RuleDefinitionReader reader, JexlEngine jexl) {
        this.reader = Objects.requireNonNull(reader, "reader cannot be null");
        this.jexl = Objects.requireNonNull(jexl, "Jexl Engine cannot be null");
    }

    public Rule createRule(Reader ruleDescriptor) throws Exception {
        Objects.requireNonNull(ruleDescriptor, "ruleDescriptor cannot be null");
        Objects.requireNonNull(this.jexl, "jexl cannot be null");
        List<RuleDefinition> ruleDefinitions = this.reader.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return this.createRule(ruleDefinitions.get(0));
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        Objects.requireNonNull(rulesDescriptor, "rulesDescriptor cannot be null");
        Rules rules = new Rules(new Rule[0]);
        List<RuleDefinition> ruleDefinitions = this.reader.read(rulesDescriptor);
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            rules.register(this.createRule(ruleDefinition));
        }
        return rules;
    }

    @Override
    protected Rule createSimpleRule(RuleDefinition ruleDefinition) {
        Objects.requireNonNull(ruleDefinition, "ruleDefinition cannot be null");
        JexlRule rule = new JexlRule(this.jexl).name(ruleDefinition.getName()).description(ruleDefinition.getDescription()).priority(ruleDefinition.getPriority()).when(ruleDefinition.getCondition());
        for (String action : ruleDefinition.getActions()) {
            rule.then(action);
        }
        return rule;
    }
}

