/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.LogicalVolumeGroup;
import oshi.hardware.NetworkIF;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.SoundCard;
import oshi.hardware.UsbDevice;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;

public class SytemInfoHelper {
    public static String getSystemInfo() {
        ArrayList<String> oshi = new ArrayList<String>();
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        OperatingSystem os = si.getOperatingSystem();
        oshi.addAll(SytemInfoHelper.printOperatingSystem(os));
        oshi.addAll(SytemInfoHelper.printComputerSystem(hal.getComputerSystem()));
        oshi.addAll(SytemInfoHelper.printProcessor(hal.getProcessor()));
        oshi.addAll(SytemInfoHelper.printMemory(hal.getMemory()));
        oshi.addAll(SytemInfoHelper.printCpu(hal.getProcessor()));
        oshi.addAll(SytemInfoHelper.printProcesses(os, hal.getMemory()));
        oshi.addAll(SytemInfoHelper.printServices(os));
        oshi.addAll(SytemInfoHelper.printSensors(hal.getSensors()));
        oshi.addAll(SytemInfoHelper.printPowerSources(hal.getPowerSources()));
        oshi.addAll(SytemInfoHelper.printDisks(hal.getDiskStores()));
        oshi.addAll(SytemInfoHelper.printLVgroups(hal.getLogicalVolumeGroups()));
        oshi.addAll(SytemInfoHelper.printFileSystem(os.getFileSystem()));
        oshi.addAll(SytemInfoHelper.printNetworkInterfaces(hal.getNetworkIFs()));
        oshi.addAll(SytemInfoHelper.printNetworkParameters(os.getNetworkParams()));
        oshi.addAll(SytemInfoHelper.printInternetProtocolStats(os.getInternetProtocolStats()));
        oshi.addAll(SytemInfoHelper.printDisplays(hal.getDisplays()));
        oshi.addAll(SytemInfoHelper.printUsbDevices(hal.getUsbDevices(true)));
        oshi.addAll(SytemInfoHelper.printSoundCards(hal.getSoundCards()));
        oshi.addAll(SytemInfoHelper.printGraphicsCards(hal.getGraphicsCards()));
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < oshi.size(); ++i) {
            output.append((String)oshi.get(i));
            if (oshi.get(i) == null || ((String)oshi.get(i)).endsWith("\n")) continue;
            output.append('\n');
        }
        return output.toString();
    }

    private static List<String> printComputerSystem(ComputerSystem computerSystem) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("System: " + computerSystem.toString());
        oshi.add(" Firmware: " + computerSystem.getFirmware().toString());
        oshi.add(" Baseboard: " + computerSystem.getBaseboard().toString());
        return oshi;
    }

    private static List<String> printCpu(CentralProcessor processor) {
        long[] freqs;
        double[] load;
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Context Switches/Interrupts: " + processor.getContextSwitches() + " / " + processor.getInterrupts());
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        long[][] prevProcTicks = processor.getProcessorCpuLoadTicks();
        oshi.add("CPU, IOWait, and IRQ ticks @ 0 sec:" + Arrays.toString(prevTicks));
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        oshi.add("CPU, IOWait, and IRQ ticks @ 1 sec:" + Arrays.toString(ticks));
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        oshi.add(String.format("User: %.1f%% Nice: %.1f%% System: %.1f%% Idle: %.1f%% IOwait: %.1f%% IRQ: %.1f%% SoftIRQ: %.1f%% Steal: %.1f%%", 100.0 * (double)user / (double)totalCpu, 100.0 * (double)nice / (double)totalCpu, 100.0 * (double)sys / (double)totalCpu, 100.0 * (double)idle / (double)totalCpu, 100.0 * (double)iowait / (double)totalCpu, 100.0 * (double)irq / (double)totalCpu, 100.0 * (double)softirq / (double)totalCpu, 100.0 * (double)steal / (double)totalCpu));
        oshi.add(String.format("CPU load: %.1f%%", processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0));
        double[] loadAverage = processor.getSystemLoadAverage(3);
        oshi.add("CPU load averages:" + (loadAverage[0] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[0])) + (loadAverage[1] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[1])) + (loadAverage[2] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[2])));
        StringBuilder procCpu = new StringBuilder("CPU load per processor:");
        for (double avg : load = processor.getProcessorCpuLoadBetweenTicks(prevProcTicks)) {
            procCpu.append(String.format(" %.1f%%", avg * 100.0));
        }
        oshi.add(procCpu.toString());
        long freq = processor.getProcessorIdentifier().getVendorFreq();
        if (freq > 0L) {
            oshi.add("Vendor Frequency: " + FormatUtil.formatHertz((long)freq));
        }
        if ((freq = processor.getMaxFreq()) > 0L) {
            oshi.add("Max Frequency: " + FormatUtil.formatHertz((long)freq));
        }
        if ((freqs = processor.getCurrentFreq())[0] > 0L) {
            StringBuilder sb = new StringBuilder("Current Frequencies: ");
            for (int i = 0; i < freqs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(FormatUtil.formatHertz((long)freqs[i]));
            }
            oshi.add(sb.toString());
        }
        return oshi;
    }

    private static List<String> printDisks(List<HWDiskStore> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Disks:");
        for (HWDiskStore disk : list) {
            oshi.add(" " + disk.toString());
            List partitions = disk.getPartitions();
            for (HWPartition part : partitions) {
                oshi.add(" |-- " + part.toString());
            }
        }
        return oshi;
    }

    private static List<String> printDisplays(List<Display> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Displays:");
        int i = 0;
        for (Display display : list) {
            oshi.add(" Display " + i + ":");
            oshi.add(String.valueOf(display));
            ++i;
        }
        return oshi;
    }

    private static List<String> printFileSystem(FileSystem fileSystem) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("File System:");
        oshi.add(String.format(" File Descriptors: %d/%d", fileSystem.getOpenFileDescriptors(), fileSystem.getMaxFileDescriptors()));
        for (OSFileStore fs : fileSystem.getFileStores()) {
            long usable = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            oshi.add(String.format(" %s (%s) [%s] %s of %s free (%.1f%%), %s of %s files free (%.1f%%) is %s " + (fs.getLogicalVolume() != null && fs.getLogicalVolume().length() > 0 ? "[%s]" : "%s") + " and is mounted at %s", fs.getName(), fs.getDescription().isEmpty() ? "file system" : fs.getDescription(), fs.getType(), FormatUtil.formatBytes((long)usable), FormatUtil.formatBytes((long)fs.getTotalSpace()), 100.0 * (double)usable / (double)total, FormatUtil.formatValue((long)fs.getFreeInodes(), (String)""), FormatUtil.formatValue((long)fs.getTotalInodes(), (String)""), 100.0 * (double)fs.getFreeInodes() / (double)fs.getTotalInodes(), fs.getVolume(), fs.getLogicalVolume(), fs.getMount()));
        }
        return oshi;
    }

    private static List<String> printGraphicsCards(List<GraphicsCard> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Graphics Cards:");
        if (list.isEmpty()) {
            oshi.add(" None detected.");
        } else {
            for (GraphicsCard card : list) {
                oshi.add(" " + String.valueOf(card));
            }
        }
        return oshi;
    }

    private static List<String> printInternetProtocolStats(InternetProtocolStats ip) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Internet Protocol statistics:");
        oshi.add(" TCPv4: " + ip.getTCPv4Stats());
        oshi.add(" TCPv6: " + ip.getTCPv6Stats());
        oshi.add(" UDPv4: " + ip.getUDPv4Stats());
        oshi.add(" UDPv6: " + ip.getUDPv6Stats());
        return oshi;
    }

    private static List<String> printLVgroups(List<LogicalVolumeGroup> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        if (!list.isEmpty()) {
            oshi.add("Logical Volume Groups:");
            for (LogicalVolumeGroup lvg : list) {
                oshi.add(" " + lvg.toString());
            }
        }
        return oshi;
    }

    private static List<String> printMemory(GlobalMemory memory) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Physical Memory: \n " + memory.toString());
        VirtualMemory vm = memory.getVirtualMemory();
        oshi.add("Virtual Memory: \n " + vm.toString());
        List pmList = memory.getPhysicalMemory();
        if (!pmList.isEmpty()) {
            oshi.add("Physical Memory: ");
            for (PhysicalMemory pm : pmList) {
                oshi.add(" " + pm.toString());
            }
        }
        return oshi;
    }

    private static List<String> printNetworkInterfaces(List<NetworkIF> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("Network Interfaces:");
        if (list.isEmpty()) {
            sb.append(" Unknown");
        } else {
            for (NetworkIF net : list) {
                sb.append("\n ").append(net.toString());
            }
        }
        oshi.add(sb.toString());
        return oshi;
    }

    private static List<String> printNetworkParameters(NetworkParams networkParams) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Network parameters:\n " + networkParams.toString());
        return oshi;
    }

    private static List<String> printOperatingSystem(OperatingSystem os) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add(String.valueOf(os));
        oshi.add("Booted: " + Instant.ofEpochSecond(os.getSystemBootTime()));
        oshi.add("Uptime: " + FormatUtil.formatElapsedSecs((long)os.getSystemUptime()));
        oshi.add("Running with" + (os.isElevated() ? "" : "out") + " elevated permissions.");
        oshi.add("Sessions:");
        for (OSSession s : os.getSessions()) {
            oshi.add(" " + s.toString());
        }
        return oshi;
    }

    private static List<String> printPowerSources(List<PowerSource> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("Power Sources: ");
        if (list.isEmpty()) {
            sb.append("Unknown");
        }
        for (PowerSource powerSource : list) {
            sb.append("\n ").append(powerSource.toString());
        }
        oshi.add(sb.toString());
        return oshi;
    }

    private static List<String> printProcesses(OperatingSystem os, GlobalMemory memory) {
        ArrayList<String> oshi = new ArrayList<String>();
        OSProcess myProc = os.getProcess(os.getProcessId());
        oshi.add("My PID: " + myProc.getProcessID() + " with affinity " + Long.toBinaryString(myProc.getAffinityMask()));
        oshi.add("Processes: " + os.getProcessCount() + ", Threads: " + os.getThreadCount());
        List procs = os.getProcesses(OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.CPU_DESC, 5);
        oshi.add("   PID  %CPU %MEM       VSZ       RSS Name");
        for (int i = 0; i < procs.size() && i < 5; ++i) {
            OSProcess p = (OSProcess)procs.get(i);
            oshi.add(String.format(" %5d %5.1f %4.1f %9s %9s %s", p.getProcessID(), 100.0 * (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUpTime(), 100.0 * (double)p.getResidentSetSize() / (double)memory.getTotal(), FormatUtil.formatBytes((long)p.getVirtualSize()), FormatUtil.formatBytes((long)p.getResidentSetSize()), p.getName()));
        }
        OSProcess p = os.getProcess(os.getProcessId());
        oshi.add("Current process arguments: ");
        for (String string : p.getArguments()) {
            oshi.add("  " + string);
        }
        oshi.add("Current process environment: ");
        for (Map.Entry entry : p.getEnvironmentVariables().entrySet()) {
            oshi.add("  " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return oshi;
    }

    private static List<String> printProcessor(CentralProcessor processor) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add(processor.toString());
        oshi.add(" Cores:");
        for (CentralProcessor.PhysicalProcessor p : processor.getPhysicalProcessors()) {
            oshi.add("  " + (String)(processor.getPhysicalPackageCount() > 1 ? p.getPhysicalPackageNumber() + "," : "") + p.getPhysicalProcessorNumber() + ": efficiency=" + p.getEfficiency() + ", id=" + p.getIdString());
        }
        return oshi;
    }

    private static List<String> printSensors(Sensors sensors) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Sensors: " + sensors.toString());
        return oshi;
    }

    private static List<String> printServices(OperatingSystem os) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Services: ");
        oshi.add("   PID   State   Name");
        int i = 0;
        for (OSService s : os.getServices()) {
            if (!s.getState().equals((Object)OSService.State.RUNNING) || i++ >= 5) continue;
            oshi.add(String.format(" %5d  %7s  %s", s.getProcessID(), s.getState(), s.getName()));
        }
        i = 0;
        for (OSService s : os.getServices()) {
            if (!s.getState().equals((Object)OSService.State.STOPPED) || i++ >= 5) continue;
            oshi.add(String.format(" %5d  %7s  %s", s.getProcessID(), s.getState(), s.getName()));
        }
        return oshi;
    }

    private static List<String> printSoundCards(List<SoundCard> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("Sound Cards:");
        for (SoundCard card : list) {
            oshi.add(" " + String.valueOf(card));
        }
        return oshi;
    }

    private static List<String> printUsbDevices(List<UsbDevice> list) {
        ArrayList<String> oshi = new ArrayList<String>();
        oshi.add("USB Devices:");
        for (UsbDevice usbDevice : list) {
            oshi.add(String.valueOf(usbDevice));
        }
        return oshi;
    }

    private SytemInfoHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

