/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rossonet.ext.rules.api.RuleListener;
import org.rossonet.ext.rules.api.RulesEngine;
import org.rossonet.ext.rules.api.RulesEngineListener;
import org.rossonet.ext.rules.api.RulesEngineParameters;

public abstract class AbstractRulesEngine
implements RulesEngine {
    RulesEngineParameters parameters;
    List<RuleListener> ruleListeners;
    List<RulesEngineListener> rulesEngineListeners;

    AbstractRulesEngine() {
        this(new RulesEngineParameters());
    }

    AbstractRulesEngine(RulesEngineParameters parameters) {
        this.parameters = parameters;
        this.ruleListeners = new ArrayList<RuleListener>();
        this.rulesEngineListeners = new ArrayList<RulesEngineListener>();
    }

    @Override
    public RulesEngineParameters getParameters() {
        return new RulesEngineParameters(this.parameters.isSkipOnFirstAppliedRule(), this.parameters.isSkipOnFirstFailedRule(), this.parameters.isSkipOnFirstNonTriggeredRule(), this.parameters.getPriorityThreshold());
    }

    @Override
    public List<RuleListener> getRuleListeners() {
        return Collections.unmodifiableList(this.ruleListeners);
    }

    @Override
    public List<RulesEngineListener> getRulesEngineListeners() {
        return Collections.unmodifiableList(this.rulesEngineListeners);
    }

    public void registerRuleListener(RuleListener ruleListener) {
        this.ruleListeners.add(ruleListener);
    }

    public void registerRuleListeners(List<RuleListener> ruleListeners) {
        this.ruleListeners.addAll(ruleListeners);
    }

    public void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        this.rulesEngineListeners.add(rulesEngineListener);
    }

    public void registerRulesEngineListeners(List<RulesEngineListener> rulesEngineListeners) {
        this.rulesEngineListeners.addAll(rulesEngineListeners);
    }
}

