/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.rossonet.ext.rules.api.Rule;
import org.rossonet.ext.rules.core.RuleProxy;

public class Rules
implements Iterable<Rule> {
    private Set<Rule> rules = new TreeSet<Rule>();

    public Rules(Object ... rules) {
        this.register(rules);
    }

    public Rules(Rule ... rules) {
        Collections.addAll(this.rules, rules);
    }

    public Rules(Set<Rule> rules) {
        this.rules = new TreeSet<Rule>(rules);
    }

    public void clear() {
        this.rules.clear();
    }

    private Rule findRuleByName(String ruleName) {
        return this.rules.stream().filter(rule -> rule.getName().equalsIgnoreCase(ruleName)).findFirst().orElse(null);
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    public void register(Object ... rules) {
        Objects.requireNonNull(rules);
        for (Object rule : rules) {
            Objects.requireNonNull(rule);
            this.rules.add(RuleProxy.asRule(rule));
        }
    }

    public int size() {
        return this.rules.size();
    }

    public void unregister(Object ... rules) {
        Objects.requireNonNull(rules);
        for (Object rule : rules) {
            Objects.requireNonNull(rule);
            this.rules.remove(RuleProxy.asRule(rule));
        }
    }

    public void unregister(String ruleName) {
        Objects.requireNonNull(ruleName);
        Rule rule = this.findRuleByName(ruleName);
        if (rule != null) {
            this.unregister(rule);
        }
    }
}

