/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.utils.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.rossonet.ext.utils.concurrent.PriorityDeque;

public class PriorityBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = 772285010852407824L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private transient Object[] deque;
    private final Comparator<? super E> comparator;
    private int size = 0;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private volatile transient AtomicInteger allocationSpinLock = new AtomicInteger(0);

    private static <T> void bubbleUp(Object[] deque, int size, int index) {
        int parentIndex = PriorityBlockingDeque.getParentIndex(index);
        if (Level.MIN.equals((Object)PriorityBlockingDeque.getLevel(size, index))) {
            if (index > 0 && ((Comparable)deque[index]).compareTo(deque[parentIndex]) > 0) {
                PriorityBlockingDeque.swap(deque, size, index, parentIndex);
                PriorityBlockingDeque.bubbleUpMax(deque, size, parentIndex);
            } else {
                PriorityBlockingDeque.bubbleUpMin(deque, size, index);
            }
        } else if (index > 0 && ((Comparable)deque[index]).compareTo(deque[parentIndex]) < 1) {
            PriorityBlockingDeque.swap(deque, size, index, parentIndex);
            PriorityBlockingDeque.bubbleUpMin(deque, size, parentIndex);
        } else {
            PriorityBlockingDeque.bubbleUpMax(deque, size, index);
        }
    }

    private static <T> void bubbleUpComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        int parentIndex = PriorityBlockingDeque.getParentIndex(index);
        if (Level.MIN.equals((Object)PriorityBlockingDeque.getLevel(size, index))) {
            if (index > 0 && comparator.compare(deque[index], deque[parentIndex]) > 0) {
                PriorityBlockingDeque.swap(deque, size, index, parentIndex);
                PriorityBlockingDeque.bubbleUpMaxComparator(deque, size, parentIndex, comparator);
            } else {
                PriorityBlockingDeque.bubbleUpMinComparator(deque, size, index, comparator);
            }
        } else if (index > 0 && comparator.compare(deque[index], deque[parentIndex]) < 1) {
            PriorityBlockingDeque.swap(deque, size, index, parentIndex);
            PriorityBlockingDeque.bubbleUpMinComparator(deque, size, parentIndex, comparator);
        } else {
            PriorityBlockingDeque.bubbleUpMaxComparator(deque, size, index, comparator);
        }
    }

    private static <T> void bubbleUpMax(Object[] deque, int size, int index) {
        int grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && ((Comparable)deque[index]).compareTo(deque[grandParentIndex]) > 0) {
            PriorityBlockingDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(grandParentIndex));
        }
    }

    private static <T> void bubbleUpMaxComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        int grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && comparator.compare(deque[index], deque[grandParentIndex]) > 0) {
            PriorityBlockingDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(grandParentIndex));
        }
    }

    private static <T> void bubbleUpMin(Object[] deque, int size, int index) {
        int grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && ((Comparable)deque[index]).compareTo(deque[grandParentIndex]) < 1) {
            PriorityBlockingDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(grandParentIndex));
        }
    }

    private static <T> void bubbleUpMinComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        int grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(index));
        while (grandParentIndex >= 0 && comparator.compare(deque[index], deque[grandParentIndex]) < 1) {
            PriorityBlockingDeque.swap(deque, size, index, grandParentIndex);
            index = grandParentIndex;
            grandParentIndex = PriorityBlockingDeque.getParentIndex(PriorityBlockingDeque.getParentIndex(grandParentIndex));
        }
    }

    private static Object[][] getChildren(Object[] deque, int size, int index) {
        Object[][] children = new Object[2][2];
        int leftChildIndex = PriorityBlockingDeque.getLeftChildIndex(index);
        int rightChildIndex = PriorityBlockingDeque.getRightChildIndex(index);
        if (PriorityBlockingDeque.isLeftChildPresent(deque, size, index)) {
            children[0][0] = deque[leftChildIndex];
            children[1][0] = leftChildIndex;
        }
        if (PriorityBlockingDeque.isRightChildPresent(deque, size, index)) {
            children[0][1] = deque[rightChildIndex];
            children[1][1] = rightChildIndex;
        }
        return children;
    }

    private static Object[][] getGrandChildren(Object[] deque, int size, int index) {
        Object[][] grandChildren = new Object[2][4];
        int leftChildIndex = PriorityBlockingDeque.getLeftChildIndex(index);
        int rightChildIndex = PriorityBlockingDeque.getRightChildIndex(index);
        int gcll = PriorityBlockingDeque.getLeftChildIndex(leftChildIndex);
        int gclr = PriorityBlockingDeque.getRightChildIndex(leftChildIndex);
        int gcrl = PriorityBlockingDeque.getLeftChildIndex(rightChildIndex);
        int gcrr = PriorityBlockingDeque.getRightChildIndex(rightChildIndex);
        if (PriorityBlockingDeque.isLeftChildPresent(deque, size, index)) {
            if (PriorityBlockingDeque.isLeftChildPresent(deque, size, leftChildIndex)) {
                grandChildren[0][0] = deque[gcll];
                grandChildren[1][0] = gcll;
            }
            if (PriorityBlockingDeque.isRightChildPresent(deque, size, leftChildIndex)) {
                grandChildren[0][1] = deque[gclr];
                grandChildren[1][1] = gclr;
            }
        }
        if (PriorityBlockingDeque.isRightChildPresent(deque, size, index)) {
            if (PriorityBlockingDeque.isLeftChildPresent(deque, size, rightChildIndex)) {
                grandChildren[0][2] = deque[gcrl];
                grandChildren[1][2] = gcrl;
            }
            if (PriorityBlockingDeque.isRightChildPresent(deque, size, rightChildIndex)) {
                grandChildren[0][3] = deque[gcrr];
                grandChildren[1][3] = gcrr;
            }
        }
        return grandChildren;
    }

    private static int getLeftChildIndex(int parentIndex) {
        return 2 * parentIndex + 1;
    }

    private static Level getLevel(int size, int index) {
        int depth;
        int noOfElements = 0;
        for (depth = 0; depth < size && index - (noOfElements = (int)((double)noOfElements + Math.pow(2.0, depth))) >= 0; ++depth) {
        }
        return depth % 2 == 0 ? Level.MIN : Level.MAX;
    }

    private static int getParentIndex(int childIndex) {
        return childIndex > 0 ? (childIndex - 1) / 2 : -1;
    }

    private static int getRightChildIndex(int parentIndex) {
        return 2 * (parentIndex + 1);
    }

    private static int indexOf(Object o, Object[] deque, int size) {
        if (o != null) {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(deque[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static <T> int indexOfLargerChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] children = PriorityBlockingDeque.getChildren(deque, size, index);
        if (children[0][0] == null && children[0][1] == null) {
            return -1;
        }
        if (children[0][0] == null) {
            return (Integer)children[1][1];
        }
        if (children[0][1] == null) {
            return (Integer)children[1][0];
        }
        if (comparator == null) {
            if (((Comparable)children[0][0]).compareTo(children[0][1]) > 0) {
                return (Integer)children[1][0];
            }
            return (Integer)children[1][1];
        }
        if (comparator.compare(children[0][0], children[0][1]) > 0) {
            return (Integer)children[1][0];
        }
        return (Integer)children[1][1];
    }

    private static <T> int indexOfLargestGrandChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] grandChildren = PriorityBlockingDeque.getGrandChildren(deque, size, index);
        Object largest = grandChildren[0][0];
        Object largestIndex = grandChildren[1][0];
        for (int count = 1; count < grandChildren[0].length; ++count) {
            if (largest == null) {
                largest = grandChildren[0][count];
                largestIndex = grandChildren[1][count];
                continue;
            }
            if (grandChildren[0][count] == null) continue;
            if (comparator == null) {
                if (((Comparable)largest).compareTo(grandChildren[0][count]) >= 0) continue;
                largest = grandChildren[0][count];
                largestIndex = grandChildren[1][count];
                continue;
            }
            if (comparator.compare(largest, grandChildren[0][count]) >= 0) continue;
            largest = grandChildren[0][count];
            largestIndex = grandChildren[1][count];
        }
        return largestIndex != null ? (Integer)largestIndex : -1;
    }

    private static <T> int indexOfSmallerChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] children = PriorityBlockingDeque.getChildren(deque, size, index);
        if (children[0][0] == null && children[0][1] == null) {
            return -1;
        }
        if (children[0][0] == null) {
            return (Integer)children[1][1];
        }
        if (children[0][1] == null) {
            return (Integer)children[1][0];
        }
        if (comparator == null) {
            if (((Comparable)children[0][0]).compareTo(children[0][1]) < 1) {
                return (Integer)children[1][0];
            }
            return (Integer)children[1][1];
        }
        if (comparator.compare(children[0][0], children[0][1]) < 1) {
            return (Integer)children[1][0];
        }
        return (Integer)children[1][1];
    }

    private static <T> int indexOfSmallestGrandChild(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        Object[][] grandChildren = PriorityBlockingDeque.getGrandChildren(deque, size, index);
        Object smallest = grandChildren[0][0];
        Object smallestIndex = grandChildren[1][0];
        for (int count = 1; count < grandChildren[0].length; ++count) {
            if (smallest == null) {
                smallest = grandChildren[0][count];
                smallestIndex = grandChildren[1][count];
                continue;
            }
            if (grandChildren[0][count] == null) continue;
            if (comparator == null) {
                if (((Comparable)smallest).compareTo(grandChildren[0][count]) <= 0) continue;
                smallest = grandChildren[0][count];
                smallestIndex = grandChildren[1][count];
                continue;
            }
            if (comparator.compare(smallest, grandChildren[0][count]) <= 0) continue;
            smallest = grandChildren[0][count];
            smallestIndex = grandChildren[1][count];
        }
        return smallestIndex != null ? (Integer)smallestIndex : -1;
    }

    private static boolean isLeftChildPresent(Object[] deque, int size, int index) {
        int leftChildIndex = PriorityBlockingDeque.getLeftChildIndex(index);
        return leftChildIndex < size && deque[leftChildIndex] != null;
    }

    private static boolean isRightChildPresent(Object[] deque, int size, int index) {
        int rightChildIndex = PriorityBlockingDeque.getRightChildIndex(index);
        return rightChildIndex < size && deque[rightChildIndex] != null;
    }

    private static void swap(Object[] deque, int size, int index1, int index2) {
        if (index1 < 0 || index1 >= size || index2 < 0 || index2 >= size) {
            throw new IllegalArgumentException();
        }
        Object temp = deque[index1];
        deque[index1] = deque[index2];
        deque[index2] = temp;
        temp = null;
    }

    private static <T> void trickleDown(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        if (Level.MIN.equals((Object)PriorityBlockingDeque.getLevel(size, index))) {
            if (comparator == null) {
                PriorityBlockingDeque.trickleDownMin(deque, size, index);
            } else {
                PriorityBlockingDeque.trickleDownMinComparator(deque, size, index, comparator);
            }
        } else if (comparator == null) {
            PriorityBlockingDeque.trickleDownMax(deque, size, index);
        } else {
            PriorityBlockingDeque.trickleDownMaxComparator(deque, size, index, comparator);
        }
    }

    private static <T> void trickleDownMax(Object[] deque, int size, int index) {
        while (index >= 0 && (PriorityBlockingDeque.isLeftChildPresent(deque, size, index) || PriorityBlockingDeque.isRightChildPresent(deque, size, index))) {
            int iLargestGc = PriorityBlockingDeque.indexOfLargestGrandChild(deque, size, index, null);
            int iLargestCh = PriorityBlockingDeque.indexOfLargerChild(deque, size, index, null);
            if (iLargestGc > 0 && ((Comparable)deque[iLargestGc]).compareTo(deque[index]) > 0) {
                PriorityBlockingDeque.swap(deque, size, index, iLargestGc);
                int parent = PriorityBlockingDeque.getParentIndex(iLargestGc);
                if (((Comparable)deque[iLargestGc]).compareTo(deque[parent]) < 1) {
                    PriorityBlockingDeque.swap(deque, size, iLargestGc, parent);
                }
            }
            if (iLargestCh > 0 && ((Comparable)deque[iLargestCh]).compareTo(deque[index]) > 0) {
                PriorityBlockingDeque.swap(deque, size, index, iLargestCh);
            }
            index = iLargestGc;
        }
    }

    private static <T> void trickleDownMaxComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        while (index >= 0 && (PriorityBlockingDeque.isLeftChildPresent(deque, size, index) || PriorityBlockingDeque.isRightChildPresent(deque, size, index))) {
            int iLargestGc = PriorityBlockingDeque.indexOfLargestGrandChild(deque, size, index, comparator);
            int iLargestCh = PriorityBlockingDeque.indexOfLargerChild(deque, size, index, comparator);
            if (iLargestGc > 0 && comparator.compare(deque[iLargestGc], deque[index]) > 0) {
                PriorityBlockingDeque.swap(deque, size, index, iLargestGc);
                int parent = PriorityBlockingDeque.getParentIndex(iLargestGc);
                if (comparator.compare(deque[iLargestGc], deque[parent]) < 1) {
                    PriorityBlockingDeque.swap(deque, size, iLargestGc, parent);
                }
            }
            if (iLargestCh > 0 && comparator.compare(deque[iLargestCh], deque[index]) > 0) {
                PriorityBlockingDeque.swap(deque, size, index, iLargestCh);
            }
            index = iLargestGc;
        }
    }

    private static <T> void trickleDownMin(Object[] deque, int size, int index) {
        while (index >= 0 && (PriorityBlockingDeque.isLeftChildPresent(deque, size, index) || PriorityBlockingDeque.isRightChildPresent(deque, size, index))) {
            int iSmallestGc = PriorityBlockingDeque.indexOfSmallestGrandChild(deque, size, index, null);
            int iSmallestCh = PriorityBlockingDeque.indexOfSmallerChild(deque, size, index, null);
            if (iSmallestGc > 0 && ((Comparable)deque[iSmallestGc]).compareTo(deque[index]) < 1) {
                PriorityBlockingDeque.swap(deque, size, index, iSmallestGc);
                int parent = PriorityBlockingDeque.getParentIndex(iSmallestGc);
                if (((Comparable)deque[iSmallestGc]).compareTo(deque[parent]) > 0) {
                    PriorityBlockingDeque.swap(deque, size, iSmallestGc, parent);
                }
            }
            if (iSmallestCh > 0 && ((Comparable)deque[iSmallestCh]).compareTo(deque[index]) < 1) {
                PriorityBlockingDeque.swap(deque, size, index, iSmallestCh);
            }
            index = iSmallestGc;
        }
    }

    private static <T> void trickleDownMinComparator(Object[] deque, int size, int index, Comparator<? super T> comparator) {
        while (index >= 0 && (PriorityBlockingDeque.isLeftChildPresent(deque, size, index) || PriorityBlockingDeque.isRightChildPresent(deque, size, index))) {
            int iSmallestGc = PriorityBlockingDeque.indexOfSmallestGrandChild(deque, size, index, comparator);
            int iSmallestCh = PriorityBlockingDeque.indexOfSmallerChild(deque, size, index, comparator);
            if (iSmallestGc > 0 && comparator.compare(deque[iSmallestGc], deque[index]) < 1) {
                PriorityBlockingDeque.swap(deque, size, index, iSmallestGc);
                int parent = PriorityBlockingDeque.getParentIndex(iSmallestGc);
                if (comparator.compare(deque[iSmallestGc], deque[parent]) > 0) {
                    PriorityBlockingDeque.swap(deque, size, iSmallestGc, parent);
                }
            }
            if (iSmallestCh > 0 && comparator.compare(deque[iSmallestCh], deque[index]) < 1) {
                PriorityBlockingDeque.swap(deque, size, index, iSmallestCh);
            }
            index = iSmallestGc;
        }
    }

    public PriorityBlockingDeque() {
        this(11, null);
    }

    public PriorityBlockingDeque(Collection<? extends E> c) {
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        if (c instanceof SortedSet) {
            SortedSet ss = (SortedSet)c;
            this.comparator = ss.comparator();
            this.addAll(ss);
        } else if (c instanceof PriorityDeque) {
            PriorityDeque pq = (PriorityDeque)c;
            this.comparator = pq.comparator();
            this.initFromPriorityDeque(pq);
        } else if (c instanceof PriorityBlockingDeque) {
            PriorityBlockingDeque pq = (PriorityBlockingDeque)c;
            this.comparator = pq.comparator();
            this.initFromPriorityBlockingDeque(pq);
        } else {
            this.comparator = null;
            this.addAll(c);
        }
    }

    public PriorityBlockingDeque(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityBlockingDeque(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.comparator = comparator;
        this.deque = new Object[initialCapacity];
    }

    public PriorityBlockingDeque(PriorityBlockingDeque<? extends E> c) {
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.comparator = c.comparator();
        this.initFromPriorityBlockingDeque(c);
    }

    public PriorityBlockingDeque(PriorityDeque<? extends E> c) {
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.comparator = c.comparator();
        this.initFromPriorityDeque(c);
    }

    public PriorityBlockingDeque(SortedSet<? extends E> c) {
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.comparator = c.comparator();
        this.addAll(c);
    }

    @Override
    public boolean add(E element) {
        return this.offer(element);
    }

    @Override
    public void addFirst(E element) {
        this.add(element);
    }

    @Override
    public void addLast(E element) {
        this.add(element);
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        int index;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            index = PriorityBlockingDeque.indexOf(o, this.deque, this.size);
        }
        finally {
            lock.unlock();
        }
        return index != -1;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new Itr(this.toArray(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e;
            int n = 0;
            while ((e = this.removeAt(0)) != null) {
                c.add(e);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e;
            int n;
            for (n = 0; n < maxElements && (e = this.removeAt(0)) != null; ++n) {
                c.add(e);
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E getFirst() {
        E x = this.peekFirst();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E getLast() {
        E x = this.peekLast();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    private void initFromPriorityBlockingDeque(PriorityBlockingDeque<? extends E> c) {
        if (c.getClass() == PriorityBlockingDeque.class) {
            this.deque = c.toArray();
            this.size = c.size();
        } else {
            this.addAll(c);
        }
    }

    private void initFromPriorityDeque(PriorityDeque<? extends E> c) {
        if (c.getClass() == PriorityDeque.class) {
            this.deque = c.toArray();
            this.size = c.size();
        } else {
            this.addAll(c);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E element) {
        int index;
        if (element == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        while (true) {
            index = this.size;
            Object[] array = this.deque;
            int cap = this.deque.length;
            if (index < cap) break;
            this.tryGrow(array, cap);
        }
        try {
            this.size = index + 1;
            if (index == 0) {
                this.deque[0] = element;
            } else {
                this.deque[index] = element;
                if (this.comparator == null) {
                    PriorityBlockingDeque.bubbleUp(this.deque, this.size, index);
                } else {
                    PriorityBlockingDeque.bubbleUpComparator(this.deque, this.size, index, this.comparator);
                }
            }
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    @Override
    public boolean offer(E element, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(element);
    }

    @Override
    public boolean offerFirst(E element) {
        return this.offer(element);
    }

    @Override
    public boolean offerFirst(E element, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(element);
    }

    @Override
    public boolean offerLast(E element) {
        return this.offer(element);
    }

    @Override
    public boolean offerLast(E element, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(element);
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        Object result;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            result = this.size > 0 ? this.deque[0] : null;
        }
        finally {
            lock.unlock();
        }
        return (E)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekLast() {
        ReentrantLock lock = this.lock;
        lock.lock();
        Object result = null;
        try {
            if (this.size > 0) {
                int indexMax = PriorityBlockingDeque.indexOfLargerChild(this.deque, this.size, 0, this.comparator);
                result = indexMax > 0 ? this.deque[indexMax] : this.deque[0];
            }
        }
        finally {
            lock.unlock();
        }
        return (E)result;
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    @Override
    public E pollFirst() {
        E result;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            result = this.removeAt(0);
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        E result;
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.removeAt(0)) == null && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast() {
        E result;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int indexMax = PriorityBlockingDeque.indexOfLargerChild(this.deque, this.size, 0, this.comparator);
            int indexRemove = indexMax > 0 ? indexMax : 0;
            result = this.removeAt(indexRemove);
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        E result;
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int indexRemove;
            int indexMax = PriorityBlockingDeque.indexOfLargerChild(this.deque, this.size, 0, this.comparator);
            int n = indexRemove = indexMax > 0 ? indexMax : 0;
            while ((result = this.removeAt(indexRemove)) == null && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    @Override
    public E pop() {
        throw new UnsupportedOperationException("Cannot use a priority blocking deque as a stack");
    }

    @Override
    public void push(E e) {
        throw new UnsupportedOperationException("Cannot use a priority blocking deque as a stack");
    }

    @Override
    public void put(E element) throws InterruptedException {
        this.offer(element);
    }

    @Override
    public void putFirst(E element) throws InterruptedException {
        this.offer(element);
    }

    @Override
    public void putLast(E element) throws InterruptedException {
        this.offer(element);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        s.readInt();
        this.deque = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.deque[i] = s.readObject();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = PriorityBlockingDeque.indexOf(o, this.deque, this.size);
            if (i == -1) {
                boolean bl = false;
                return bl;
            }
            this.removeAt(i);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private E removeAt(int index) {
        if (this.size > 0) {
            Object obj = this.deque[index];
            --this.size;
            if (this.size > 0) {
                this.deque[index] = this.deque[this.size];
                this.deque[this.size] = null;
                PriorityBlockingDeque.trickleDown(this.deque, this.size, index, this.comparator);
            } else {
                this.deque[index] = null;
            }
            return (E)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEQ(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] array = this.deque;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (o != array[i]) continue;
                this.removeAt(i);
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            int firstIndex = -1;
            for (int count = 0; count < this.size; ++count) {
                if (!this.deque[count].equals(o)) continue;
                firstIndex = count;
                break;
            }
            if (firstIndex >= 0) {
                this.removeAt(firstIndex);
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x != null) {
            return x;
        }
        throw new NoSuchElementException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            int lastIndex = -1;
            for (int count = this.size - 1; count >= 0; --count) {
                if (!this.deque[count].equals(o)) continue;
                lastIndex = count;
                break;
            }
            if (lastIndex >= 0) {
                this.removeAt(lastIndex);
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E takeFirst() throws InterruptedException {
        E result;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.removeAt(0)) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        E result;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            int indexRemove;
            int indexMax = PriorityBlockingDeque.indexOfLargerChild(this.deque, this.size, 0, this.comparator);
            int n = indexRemove = indexMax > 0 ? indexMax : 0;
            while ((result = this.removeAt(indexRemove)) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = Arrays.copyOf(this.deque, this.size);
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (a.length < this.size) {
                T[] TArray = Arrays.copyOf(this.deque, this.size, a.getClass());
                return TArray;
            }
            System.arraycopy(this.deque, 0, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            T[] TArray = a;
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            if (n == 0) {
                String string = "[]";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < n; ++i) {
                Object e = this.deque[i];
                sb.append(e == this ? "(this Collection)" : e);
                if (i == n - 1) continue;
                sb.append(',').append(' ');
            }
            String string = sb.append(']').toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryGrow(Object[] array, int oldCap) {
        this.lock.unlock();
        Object[] newArray = null;
        if (this.allocationSpinLock.get() == 0 && this.allocationSpinLock.compareAndSet(0, 1)) {
            try {
                int newCap = oldCap + (oldCap < 64 ? oldCap + 2 : oldCap >> 1);
                if (newCap - 0x7FFFFFF7 > 0) {
                    int minCap = oldCap + 1;
                    if (minCap < 0 || minCap > 0x7FFFFFF7) {
                        throw new OutOfMemoryError();
                    }
                    newCap = 0x7FFFFFF7;
                }
                if (newCap > oldCap && this.deque == array) {
                    newArray = new Object[newCap];
                }
            }
            finally {
                this.allocationSpinLock.set(0);
            }
        }
        if (newArray == null) {
            Thread.yield();
        }
        this.lock.lock();
        if (newArray != null && this.deque == array) {
            this.deque = newArray;
            System.arraycopy(array, 0, newArray, 0, oldCap);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lock.lock();
        try {
            s.defaultWriteObject();
            s.writeInt(Math.max(2, this.size + 1));
            for (int i = 0; i < this.size; ++i) {
                s.writeObject(this.deque[i]);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum Level {
        MIN,
        MAX;

    }

    final class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;
        boolean desc;

        Itr(Object[] array, boolean desc) {
            this.array = array;
            this.desc = desc;
            if (desc) {
                this.cursor = this.array.length - 1;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.desc && this.cursor < this.array.length || this.desc && this.cursor >= 0;
        }

        @Override
        public E next() {
            if (!this.desc) {
                return this.nextAsc();
            }
            if (this.desc) {
                return this.nextDesc();
            }
            throw new NoSuchElementException();
        }

        private E nextAsc() {
            if (this.cursor < this.array.length) {
                this.lastRet = this.cursor++;
                return this.array[this.lastRet];
            }
            throw new NoSuchElementException();
        }

        private E nextDesc() {
            if (this.cursor >= 0) {
                this.lastRet = this.cursor--;
                return this.array[this.lastRet];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            PriorityBlockingDeque.this.removeEQ(this.array[this.lastRet]);
            this.lastRet = -1;
        }
    }
}

