/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.rules.base;

import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.rossonet.ext.rules.api.Fact;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.rules.base.CachedMemory;
import org.rossonet.rules.base.Command;
import org.rossonet.rules.base.CommandQueue;
import org.rossonet.utils.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesContext {
    private static final String DEFAULT_CLASS_LIST_SEPARATOR = ", ";
    private static final Map<String, Class<? extends Command>> commands = new HashMap<String, Class<? extends Command>>();
    private static Logger logger = LoggerFactory.getLogger(RulesContext.class);
    private final CommandQueue commandQueue;
    private final Facts facts;

    public static int registerCommand(String label, Class<? extends Command> command) {
        commands.put(label, command);
        return commands.size();
    }

    public RulesContext(CommandQueue commandQueue, Facts facts) {
        this.facts = facts;
        this.commandQueue = commandQueue;
    }

    public <T> void addFact(String factName, T payload) {
        this.facts.add(new Fact<T>(factName, payload));
    }

    public String epochMilliToText(long epoch) {
        return Instant.ofEpochMilli(epoch).toString();
    }

    public String epochSecondToText(long epoch) {
        return Instant.ofEpochSecond(epoch).toString();
    }

    public void error(String msg) {
        logger.error("\u001b[1;31m" + msg + "\u001b[0m");
    }

    public void exec(String command, Object ... data) {
        if (commands.containsKey(command)) {
            try {
                Command commandObject = (Command)commands.get(command).getConstructors()[0].newInstance(new Object[0]);
                if (data != null) {
                    commandObject.setData(data);
                }
                this.commandQueue.offer(commandObject);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                logger.error("\u001b[0;31mcommand " + command + " got error \u001b[0m" + LogHelper.stackTraceToString(e, 5));
            }
        } else {
            logger.error(command + " not found [" + commands + "]");
        }
    }

    public List<Object> getByClass(String factClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Fact<?> f : this.facts) {
            String simpleName = f.getValue().getClass().getSimpleName();
            String name = f.getValue().getClass().getName();
            if (!simpleName.equals(factClass) && !name.startsWith(factClass)) continue;
            result.add(f.getValue());
        }
        return result;
    }

    public long getEpochMs() {
        return Instant.now().toEpochMilli();
    }

    public Fact<?> getFact(String factName) {
        for (Fact<?> f : this.facts) {
            if (!f.getName().equals(factName)) continue;
            return f;
        }
        return null;
    }

    public void info(String msg) {
        logger.info("\u001b[1;35m" + msg + "\u001b[0m");
    }

    public boolean isCachedMemoryPresent() {
        return this.facts.asMap().containsKey("mem") && this.facts.asMap().get("mem").getClass().equals(CachedMemory.class);
    }

    public boolean isPresent(String factName) {
        for (Fact<?> f : this.facts) {
            if (!f.getName().equals(factName)) continue;
            return true;
        }
        return false;
    }

    public boolean isPresentByClass(String factClass) {
        for (Fact<?> f : this.facts) {
            String simpleName = f.getValue().getClass().getSimpleName();
            String name = f.getValue().getClass().getName();
            if (!simpleName.equals(factClass) && !name.equals(factClass)) continue;
            return true;
        }
        return false;
    }

    public String listAllFactsByClass() {
        return this.listAllFactsByClass(DEFAULT_CLASS_LIST_SEPARATOR);
    }

    public String listAllFactsByClass(String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Fact<?> f : this.facts) {
            String simpleName = f.getValue().getClass().getSimpleName();
            String name = f.getValue().getClass().getName();
            if (!first) {
                result.append(separator);
            }
            result.append(f.getName() + " - " + simpleName + " [" + name + "]");
            first = false;
        }
        return result.toString();
    }

    public int randomNumber(int minValue, int maxValue) {
        return ThreadLocalRandom.current().nextInt(minValue, maxValue + 1);
    }

    public void removeFact(String factName) {
        Fact<?> toDelete = null;
        for (Fact<?> f : this.facts) {
            if (!f.getName().equals(factName)) continue;
            toDelete = f;
            break;
        }
        if (toDelete != null) {
            this.facts.remove(toDelete);
        }
    }

    public boolean test(boolean condition) {
        logger.info("called test condition " + condition);
        return condition;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RulesContext [");
        if (this.commandQueue != null) {
            builder.append(this.commandQueue);
        }
        builder.append("]");
        return builder.toString();
    }

    public UUID uuid() {
        return UUID.randomUUID();
    }

    public void warning(String msg) {
        logger.warn("\u001b[1;35m" + msg + "\u001b[0m");
    }
}

