/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.rules.base;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.rossonet.ext.rules.api.Fact;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.ext.rules.api.Rules;
import org.rossonet.ext.rules.api.RulesEngine;
import org.rossonet.ext.rules.core.DefaultRulesEngine;
import org.rossonet.ext.rules.mvel.MVELRuleFactory;
import org.rossonet.ext.rules.support.AbstractRuleFactory;
import org.rossonet.ext.rules.support.reader.JsonRuleDefinitionReader;
import org.rossonet.rules.base.BaseRulesEngine;
import org.rossonet.rules.base.CachedMemory;
import org.rossonet.rules.base.CommandQueue;
import org.rossonet.rules.base.FactProvider;
import org.rossonet.rules.base.RuleProvider;
import org.rossonet.rules.base.RulesContext;
import org.rossonet.utils.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseRulesEngine
implements BaseRulesEngine {
    public static final String CTX = "ctx";
    public static final String MEM = "mem";
    private static final String MAT = "mat";
    private final Set<FactProvider> factsProviders = Collections.synchronizedSet(new HashSet());
    private final Set<RuleProvider> rulesProviders = Collections.synchronizedSet(new HashSet());
    private RulesEngine rulesEngine;
    private final Logger logger = LoggerFactory.getLogger(AbstractBaseRulesEngine.class);
    private BaseRulesEngine.RulesEngineStatus status = BaseRulesEngine.RulesEngineStatus.INIT;
    private CachedMemory cachedMemory;
    private final AbstractRuleFactory ruleFactory;

    public AbstractBaseRulesEngine() {
        this(new MVELRuleFactory(new JsonRuleDefinitionReader()));
    }

    public AbstractBaseRulesEngine(AbstractRuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
        this.resetAndInitialize();
        this.status = BaseRulesEngine.RulesEngineStatus.ACTIVE;
    }

    @Override
    public void addFactProvider(FactProvider factProvider) {
        this.factsProviders.add(factProvider);
    }

    @Override
    public void addRulesProvider(RuleProvider ruleProvider) {
        this.rulesProviders.add(ruleProvider);
    }

    @Override
    public void clearFacts() {
        this.factsProviders.clear();
        this.factsProviders.add(this.cachedMemory);
    }

    @Override
    public void clearRules() {
        this.rulesProviders.clear();
    }

    private Rules createRules(JSONArray rules) throws Exception {
        Rules outputRules = this.ruleFactory.createRules(new StringReader(rules.toString()));
        if (outputRules != null) {
            this.logger.debug("\u001b[0;32mfound " + outputRules.size() + " rules\u001b[0m");
        } else {
            this.logger.warn("\u001b[0;31mNO RULES found\u001b[0m");
        }
        return outputRules;
    }

    @Override
    public CommandQueue fireRules() {
        Facts facts = new Facts();
        for (FactProvider factProvider : this.factsProviders) {
            if (factProvider == null || factProvider.getFacts() == null) continue;
            for (Fact<?> f : factProvider.getFacts()) {
                facts.put(f.getName(), f.getValue());
            }
        }
        JSONArray rules = new JSONArray();
        for (RuleProvider rp : this.rulesProviders) {
            this.logger.debug("fire with " + rp.getRules().length() + " rules and " + facts.asMap().size() + " facts");
            rules.putAll(rp.getRules());
        }
        CommandQueue commandQueue = new CommandQueue();
        try {
            Rules activeRules = this.createRules(rules);
            facts.add(new Fact<RulesContext>(CTX, new RulesContext(commandQueue, facts)));
            facts.add(new Fact<Class<Math>>(MAT, Math.class));
            this.rulesEngine.fire(activeRules, facts);
        }
        catch (Exception e) {
            this.logger.error("\u001b[0;31mfire fault\u001b[0m" + LogHelper.stackTraceToString(e, 5));
        }
        return commandQueue;
    }

    @Override
    public CachedMemory getCachedMemory() {
        return this.cachedMemory;
    }

    public RulesEngine getRulesEngine() {
        return this.rulesEngine;
    }

    @Override
    public BaseRulesEngine.RulesEngineStatus getStatus() {
        return this.status;
    }

    @Override
    public void resetAndInitialize() {
        this.resetAndInitialize(new DefaultRulesEngine());
    }

    @Override
    public void resetAndInitialize(RulesEngine rulesEngine) {
        this.status = BaseRulesEngine.RulesEngineStatus.INIT;
        this.clearFacts();
        this.clearRules();
        this.rulesEngine = rulesEngine;
        this.status = BaseRulesEngine.RulesEngineStatus.ACTIVE;
    }

    @Override
    public void setCachedMemory(CachedMemory cachedMemory) {
        if (this.factsProviders.contains(this.cachedMemory)) {
            this.factsProviders.remove(cachedMemory);
        }
        this.cachedMemory = cachedMemory;
        this.factsProviders.add(cachedMemory);
    }
}

