/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.api;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fact<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fact.class);
    private static int maxCharsInValueToString = 80;
    private static boolean humanDateInToString = true;
    private static final String DIGEST_ALGHORITM = "SHA-256";
    private static MessageDigest digest;
    private final String name;
    private final T value;
    private final long createdAt;

    public static int getMaxCharsInValueToString() {
        return maxCharsInValueToString;
    }

    public static boolean isHumanDateInToString() {
        return humanDateInToString;
    }

    public static void setHumanDateInToString(boolean humanDateInToString) {
        Fact.humanDateInToString = humanDateInToString;
    }

    public static void setMaxCharsInValueToString(int maxCharsInValueToString) {
        Fact.maxCharsInValueToString = maxCharsInValueToString;
    }

    public Fact(String name, T value) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(value, "value must not be null");
        this.name = name;
        this.value = value;
        this.createdAt = Instant.now().toEpochMilli();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fact fact = (Fact)o;
        return this.name.equals(fact.name);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        Object valueString = "";
        if (this.value != null) {
            valueString = this.value.toString().length() <= maxCharsInValueToString ? this.value.toString() : this.value.toString().substring(0, maxCharsInValueToString) + "[" + new String(digest.digest(this.value.toString().getBytes(StandardCharsets.UTF_8))) + "]";
        }
        return "Fact{time=" + (humanDateInToString ? Instant.ofEpochMilli(this.createdAt).toString() : String.valueOf(this.createdAt)) + ", name='" + this.name + "', value=" + (String)valueString + "}";
    }

    static {
        try {
            digest = MessageDigest.getInstance(DIGEST_ALGHORITM);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("");
        }
    }
}

