/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.rules.base;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rossonet.ext.rules.api.Fact;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.rules.base.CommandExecuter;
import org.rossonet.rules.base.FactProvider;

public class CachedMemory
implements FactProvider,
CommandExecuter {
    private final List<TimerCachedMemory> factsMemory = Collections.synchronizedList(new ArrayList());

    public void clear() {
        this.factsMemory.clear();
    }

    @Override
    public Facts getFacts() {
        Facts reply = new Facts();
        ArrayList<TimerCachedMemory> toDelete = new ArrayList<TimerCachedMemory>();
        for (TimerCachedMemory memoryFact : this.factsMemory) {
            if (memoryFact.isValidNow()) {
                reply.add(memoryFact.getFact());
            }
            if (!memoryFact.isExpired()) continue;
            toDelete.add(memoryFact);
        }
        reply.add(new Fact<CachedMemory>("mem", this));
        for (TimerCachedMemory expiredFact : toDelete) {
            this.factsMemory.remove(expiredFact);
        }
        return reply;
    }

    public void remove(String factName) {
        TimerCachedMemory toDelete = null;
        for (TimerCachedMemory f : this.factsMemory) {
            if (!f.getName().equals(factName)) continue;
            toDelete = f;
            break;
        }
        if (toDelete != null) {
            this.factsMemory.remove(toDelete);
        }
    }

    public <F> void save(String name, F payload) {
        this.save(name, payload, -1L, -1L);
    }

    public <F> void save(String name, F payload, long validDelayMs, long validUntilMs) {
        this.factsMemory.add(new TimerCachedMemory(name, validDelayMs, validUntilMs, new Fact<F>(name, payload)));
    }

    public String toString() {
        int maxLen = 20;
        StringBuilder builder = new StringBuilder();
        builder.append("CachedMemory [");
        if (this.factsMemory != null) {
            builder.append("factsMemory=");
            builder.append(this.factsMemory.subList(0, Math.min(this.factsMemory.size(), 20)));
        }
        builder.append("]");
        return builder.toString();
    }

    public class TimerCachedMemory {
        private final String name;
        private final long validDelayMs;
        private final long validUntilMs;
        private final Fact<?> fact;
        private final long createdAt;

        public TimerCachedMemory(String name, long validDelayMs, long validUntilMs, Fact<?> fact) {
            this.name = name;
            this.validDelayMs = validDelayMs;
            this.validUntilMs = validUntilMs;
            this.fact = fact;
            this.createdAt = Instant.now().toEpochMilli();
        }

        public long getCreatedAt() {
            return this.createdAt;
        }

        public Fact<?> getFact() {
            return this.fact;
        }

        public String getName() {
            return this.name;
        }

        public long getValidDelayMs() {
            return this.validDelayMs;
        }

        public long getValidUntilMs() {
            return this.validUntilMs;
        }

        public boolean isExpired() {
            return this.validUntilMs != -1L && this.createdAt + this.validUntilMs < Instant.now().toEpochMilli();
        }

        public boolean isValidNow() {
            if (this.validDelayMs != -1L && this.createdAt + this.validDelayMs > Instant.now().toEpochMilli()) {
                return false;
            }
            return !this.isExpired();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TimerCachedMemory [");
            if (this.name != null) {
                builder.append("name=");
                builder.append(this.name);
                builder.append(", ");
            }
            builder.append("createdAt=");
            builder.append(this.createdAt);
            builder.append(", validDelayMs=");
            builder.append(this.validDelayMs);
            builder.append(", validUntilMs=");
            builder.append(this.validUntilMs);
            builder.append(", ");
            if (this.fact != null) {
                builder.append("fact=");
                builder.append(this.fact);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

