/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.brain.api.astrocyte.synapse;

import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;

public class BrainThreadLogLine {
    private String state;
    private StackTraceElement[] stackTrace;
    private int threadPriority;
    private String threadName;
    private long threadId;
    private int nanos;
    private long time;
    private String synapseId;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public int getNanos() {
        return this.nanos;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public String getState() {
        return this.state;
    }

    public String getSynapseId() {
        return this.synapseId;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public long getTime() {
        return this.time;
    }

    public void setInstant(Instant time) {
        this.time = time.getEpochSecond();
        this.nanos = time.getNano();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNanos(int nanos) {
        this.nanos = nanos;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setSynapse(UUID universallyUniqueIdentifier) {
        this.synapseId = universallyUniqueIdentifier.toString();
    }

    public void setSynapseId(String synapseId) {
        this.synapseId = synapseId;
    }

    public void setThreadId(long id) {
        this.threadId = id;
    }

    public void setThreadName(String name) {
        this.threadName = name;
    }

    public void setThreadPriority(int priority) {
        this.threadPriority = priority;
    }

    public void setThreadStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setThreadState(Thread.State state) {
        this.state = state.name();
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BrainThreadLogLine [");
        if (this.message != null) {
            builder.append("message=");
            builder.append(this.message);
            builder.append(", ");
        }
        if (this.state != null) {
            builder.append("state=");
            builder.append(this.state);
            builder.append(", ");
        }
        if (this.threadName != null) {
            builder.append("threadName=");
            builder.append(this.threadName);
            builder.append(", ");
        }
        builder.append("threadId=");
        builder.append(this.threadId);
        builder.append(", threadPriority=");
        builder.append(this.threadPriority);
        builder.append(", time=");
        builder.append(this.time);
        builder.append(", nanos=");
        builder.append(this.nanos);
        builder.append(", ");
        if (this.synapseId != null) {
            builder.append("synapseId=");
            builder.append(this.synapseId);
            builder.append(", ");
        }
        if (this.stackTrace != null) {
            builder.append("stackTrace=");
            builder.append(Arrays.toString(this.stackTrace));
        }
        builder.append("]");
        return builder.toString();
    }
}

