/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;
import org.rossonet.utils.text.PlaceHolder;

public final class TextHelper {
    private static String encryptionAlgorithm = "AES";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[0;30m";
    public static final String ANSI_RED = "\u001b[0;31m";
    public static final String ANSI_GREEN = "\u001b[0;32m";
    public static final String ANSI_YELLOW = "\u001b[0;33m";
    public static final String ANSI_BLUE = "\u001b[0;34m";
    public static final String ANSI_PURPLE = "\u001b[0;35m";
    public static final String ANSI_CYAN = "\u001b[0;36m";
    public static final String ANSI_WHITE = "\u001b[0;37m";
    public static final String ANSI_BLACK_BOLD = "\u001b[1;30m";
    public static final String ANSI_RED_BOLD = "\u001b[1;31m";
    public static final String ANSI_GREEN_BOLD = "\u001b[1;32m";
    public static final String ANSI_YELLOW_BOLD = "\u001b[1;33m";
    public static final String ANSI_BLUE_BOLD = "\u001b[1;34m";
    public static final String ANSI_PURPLE_BOLD = "\u001b[1;35m";
    public static final String ANSI_CYAN_BOLD = "\u001b[1;36m";
    public static final String ANSI_WHITE_BOLD = "\u001b[1;37m";
    public static final String ANSI_BLACK_UNDERLINED = "\u001b[4;30m";
    public static final String ANSI_RED_UNDERLINED = "\u001b[4;31m";
    public static final String ANSI_GREEN_UNDERLINED = "\u001b[4;32m";
    public static final String ANSI_YELLOW_UNDERLINED = "\u001b[4;33m";
    public static final String ANSI_BLUE_UNDERLINED = "\u001b[4;34m";
    public static final String ANSI_PURPLE_UNDERLINED = "\u001b[4;35m";
    public static final String ANSI_CYAN_UNDERLINED = "\u001b[4;36m";
    public static final String ANSI_WHITE_UNDERLINED = "\u001b[4;37m";
    public static final String ANSI_BLACK_BACKGROUND = "\u001b[40m";
    public static final String ANSI_RED_BACKGROUND = "\u001b[41m";
    public static final String ANSI_GREEN_BACKGROUND = "\u001b[42m";
    public static final String ANSI_YELLOW_BACKGROUND = "\u001b[43m";
    public static final String ANSI_BLUE_BACKGROUND = "\u001b[44m";
    public static final String ANSI_PURPLE_BACKGROUND = "\u001b[45m";
    public static final String ANSI_CYAN_BACKGROUND = "\u001b[46m";
    public static final String ANSI_WHITE_BACKGROUND = "\u001b[47m";
    public static final String ANSI_BLACK_BRIGHT = "\u001b[0;90m";
    public static final String ANSI_RED_BRIGHT = "\u001b[0;91m";
    public static final String ANSI_GREEN_BRIGHT = "\u001b[0;92m";
    public static final String ANSI_YELLOW_BRIGHT = "\u001b[0;93m";
    public static final String ANSI_BLUE_BRIGHT = "\u001b[0;94m";
    public static final String ANSI_PURPLE_BRIGHT = "\u001b[0;95m";
    public static final String ANSI_CYAN_BRIGHT = "\u001b[0;96m";
    public static final String ANSI_WHITE_BRIGHT = "\u001b[0;97m";
    public static final String ANSI_BLACK_BOLD_BRIGHT = "\u001b[1;90m";
    public static final String ANSI_RED_BOLD_BRIGHT = "\u001b[1;91m";
    public static final String ANSI_GREEN_BOLD_BRIGHT = "\u001b[1;92m";
    public static final String ANSI_YELLOW_BOLD_BRIGHT = "\u001b[1;93m";
    public static final String ANSI_BLUE_BOLD_BRIGHT = "\u001b[1;94m";
    public static final String ANSI_PURPLE_BOLD_BRIGHT = "\u001b[1;95m";
    public static final String ANSI_CYAN_BOLD_BRIGHT = "\u001b[1;96m";
    public static final String ANSI_WHITE_BOLD_BRIGHT = "\u001b[1;97m";
    public static final String ANSI_BLACK_BACKGROUND_BRIGHT = "\u001b[0;100m";
    public static final String ANSI_RED_BACKGROUND_BRIGHT = "\u001b[0;101m";
    public static final String ANSI_GREEN_BACKGROUND_BRIGHT = "\u001b[0;102m";
    public static final String ANSI_YELLOW_BACKGROUND_BRIGHT = "\u001b[0;103m";
    public static final String ANSI_BLUE_BACKGROUND_BRIGHT = "\u001b[0;104m";
    public static final String ANSI_PURPLE_BACKGROUND_BRIGHT = "\u001b[0;105m";
    public static final String ANSI_CYAN_BACKGROUND_BRIGHT = "\u001b[0;106m";
    public static final String ANSI_WHITE_BACKGROUND_BRIGHT = "\u001b[0;107m";

    public static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    public static byte[] decryptData(byte[] encryptedData, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return TextHelper.decryptData(encryptedData, key, encryptionAlgorithm);
    }

    public static byte[] decryptData(byte[] encryptedData, byte[] key, String encryptionAlgorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher c = Cipher.getInstance(encryptionAlgorithm);
        SecretKeySpec k = new SecretKeySpec(key, encryptionAlgorithm);
        c.init(2, k);
        return c.doFinal(encryptedData);
    }

    public static byte[] encryptData(byte[] dataToEncrypt, byte[] key) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        return TextHelper.encryptData(dataToEncrypt, key, encryptionAlgorithm);
    }

    public static byte[] encryptData(byte[] dataToEncrypt, byte[] key, String encryptionAlgorithm) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher c = Cipher.getInstance(encryptionAlgorithm);
        SecretKeySpec k = new SecretKeySpec(key, encryptionAlgorithm);
        c.init(1, k);
        return c.doFinal(dataToEncrypt);
    }

    public static Map<String, PlaceHolder> extractPlaceHolderFromText(String originalText, String startPlaceholderText, String stopPlaceholderText) {
        Pattern pattern = Pattern.compile(startPlaceholderText + ".+?" + stopPlaceholderText);
        return TextHelper.extractPlaceHolderFromText(originalText, startPlaceholderText, stopPlaceholderText, pattern);
    }

    public static Map<String, PlaceHolder> extractPlaceHolderFromText(String originalText, String startPlaceholderText, String stopPlaceholderText, Pattern pattern) {
        Matcher m = pattern.matcher(originalText);
        HashMap<String, PlaceHolder> placeHolders = new HashMap<String, PlaceHolder>();
        if (m.find()) {
            do {
                String placeholder;
                PlaceHolder dataPlaceholder;
                if ((dataPlaceholder = new PlaceHolder(placeholder = m.group(), startPlaceholderText, stopPlaceholderText)).getDataWithoutPlaceholderTag() == null || dataPlaceholder.getDataWithoutPlaceholderTag().isEmpty() || placeHolders.containsKey(dataPlaceholder.getDataWithoutPlaceholderTag())) continue;
                placeHolders.put(dataPlaceholder.getDataWithoutPlaceholderTag(), dataPlaceholder);
            } while (m.find());
        }
        return placeHolders;
    }

    public static String getDefaultEncryptionAlgorithm() {
        return encryptionAlgorithm;
    }

    public static JSONObject getJsonFromMap(Map<String, String> map) {
        JSONObject json = new JSONObject();
        for (String key : map.keySet()) {
            json.put(key, (Object)map.get(key));
        }
        return json;
    }

    public static Map<String, String> getMapFromJson(JSONObject jsonMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : jsonMap.keySet()) {
            map.put(key, jsonMap.getString(key));
        }
        return map;
    }

    public static Map<String, String> getParametersInUrlQuery(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    public static String joinCollection(Collection<?> data, String separator) {
        if (data.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Object d : data.toArray()) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(d);
        }
        return result.toString();
    }

    public static <O extends Serializable> O objectFromString(String string, Class<O> clazz) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(string);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return (O)((Serializable)o);
    }

    public static String objectToString(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    public static String popolateTextPlaceholdersFromData(String originalText, Map<String, String> data, String startPlaceholderText, String stopPlaceholderText) {
        Pattern pattern = Pattern.compile(startPlaceholderText + ".+?" + stopPlaceholderText);
        return TextHelper.popolateTextPlaceholdersFromData(originalText, data, startPlaceholderText, stopPlaceholderText, pattern);
    }

    public static String popolateTextPlaceholdersFromData(String originalText, Map<String, String> data, String startPlaceholderText, String stopPlaceholderText, Pattern PATTERN) {
        Matcher m = PATTERN.matcher(originalText);
        StringBuilder reply = new StringBuilder();
        if (m.find()) {
            int indexStart = 0;
            do {
                reply.append(originalText.substring(indexStart, m.start()));
                String placeHoldername = m.group().replaceAll("^" + startPlaceholderText, "").replaceAll(stopPlaceholderText + "$", "");
                if (data.containsKey(placeHoldername)) {
                    reply.append(data.get(placeHoldername));
                } else {
                    new UnsupportedOperationException("found placeholder without key: " + placeHoldername);
                }
                indexStart = m.end();
            } while (m.find());
            reply.append(originalText.substring(indexStart, originalText.length()));
        } else {
            reply.append(originalText);
        }
        return reply.toString();
    }

    public static void setDefaultEncryptionAlgorithm(String encryptionAlgorithm) {
        TextHelper.encryptionAlgorithm = encryptionAlgorithm;
    }

    public static List<String> splitFixSize(String s, int chunkSize) {
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i < s.length(); i += chunkSize) {
            chunks.add(s.substring(i, Math.min(s.length(), i + chunkSize)));
        }
        return chunks;
    }

    private TextHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

