/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.utils;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.rossonet.ext.utils.SelfSignedCertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedCertificateBuilder {
    public static final String SA_SHA1_RSA = "SHA1withRSA";
    public static final String SA_SHA256_RSA = "SHA256withRSA";
    public static final String SA_SHA256_ECDSA = "SHA256withECDSA";
    private Period validityPeriod = Period.ofYears(3);
    private String commonName = "";
    private String organization = "";
    private String organizationalUnit = "";
    private String localityName = "";
    private String stateName = "";
    private String countryCode = "";
    private String applicationUri = "";
    private final List<String> dnsNames = new ArrayList<String>();
    private final List<String> ipAddresses = new ArrayList<String>();
    private String signatureAlgorithm = "SHA256withRSA";
    private final KeyPair keyPair;
    private final SelfSignedCertificateGenerator generator;

    public SelfSignedCertificateBuilder(KeyPair keyPair) {
        this(keyPair, new SelfSignedCertificateGenerator());
    }

    public SelfSignedCertificateBuilder(KeyPair keyPair, SelfSignedCertificateGenerator generator) {
        this.keyPair = keyPair;
        this.generator = generator;
        PublicKey publicKey = keyPair.getPublic();
        if (publicKey instanceof RSAPublicKey) {
            this.signatureAlgorithm = SA_SHA256_RSA;
            int bitLength = ((RSAPublicKey)keyPair.getPublic()).getModulus().bitLength();
            if (bitLength <= 1024) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                logger.warn("Using legacy key size: {}", (Object)bitLength);
            }
        } else if (keyPair.getPublic() instanceof ECPublicKey) {
            this.signatureAlgorithm = SA_SHA256_ECDSA;
        }
    }

    public SelfSignedCertificateBuilder addDnsName(String dnsName) {
        this.dnsNames.add(dnsName);
        return this;
    }

    public SelfSignedCertificateBuilder addIpAddress(String ipAddress) {
        this.ipAddresses.add(ipAddress);
        return this;
    }

    public X509Certificate build() throws Exception {
        LocalDate now = LocalDate.now();
        LocalDate expiration = now.plus(this.validityPeriod);
        Date notBefore = Date.from(now.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date notAfter = Date.from(expiration.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return this.generator.generateSelfSigned(this.keyPair, notBefore, notAfter, this.commonName, this.organization, this.organizationalUnit, this.localityName, this.stateName, this.countryCode, this.applicationUri, this.dnsNames, this.ipAddresses, this.signatureAlgorithm);
    }

    public SelfSignedCertificateBuilder setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public SelfSignedCertificateBuilder setCommonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    public SelfSignedCertificateBuilder setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public SelfSignedCertificateBuilder setLocalityName(String localityName) {
        this.localityName = localityName;
        return this;
    }

    public SelfSignedCertificateBuilder setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public SelfSignedCertificateBuilder setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
        return this;
    }

    public SelfSignedCertificateBuilder setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public SelfSignedCertificateBuilder setStateName(String stateName) {
        this.stateName = stateName;
        return this;
    }

    public SelfSignedCertificateBuilder setValidityPeriod(Period validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }
}

