/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.ext.rules.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.rossonet.ext.rules.annotation.Action;
import org.rossonet.ext.rules.annotation.Condition;
import org.rossonet.ext.rules.annotation.Fact;
import org.rossonet.ext.rules.annotation.Priority;
import org.rossonet.ext.rules.annotation.Rule;
import org.rossonet.ext.rules.api.Facts;
import org.rossonet.ext.rules.core.Utils;

class RuleDefinitionValidator {
    RuleDefinitionValidator() {
    }

    private void checkActionMethods(Object rule) {
        List<Method> actionMethods = this.getMethodsAnnotatedWith(Action.class, rule);
        if (actionMethods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have at least one public method annotated with '%s'", rule.getClass().getName(), Action.class.getName()));
        }
        for (Method actionMethod : actionMethods) {
            if (this.isActionMethodWellDefined(actionMethod)) continue;
            throw new IllegalArgumentException(String.format("Action method '%s' defined in rule '%s' must be public, must return void type and may have parameters annotated with @Fact (and/or exactly one parameter of type Facts or one of its sub-types).", actionMethod, rule.getClass().getName()));
        }
    }

    private void checkConditionMethod(Object rule) {
        List<Method> conditionMethods = this.getMethodsAnnotatedWith(Condition.class, rule);
        if (conditionMethods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have a public method annotated with '%s'", rule.getClass().getName(), Condition.class.getName()));
        }
        if (conditionMethods.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", rule.getClass().getName(), Condition.class.getName()));
        }
        Method conditionMethod = conditionMethods.get(0);
        if (!this.isConditionMethodWellDefined(conditionMethod)) {
            throw new IllegalArgumentException(String.format("Condition method '%s' defined in rule '%s' must be public, must return boolean type and may have parameters annotated with @Fact (and/or exactly one parameter of type Facts or one of its sub-types).", conditionMethod, rule.getClass().getName()));
        }
    }

    private void checkPriorityMethod(Object rule) {
        List<Method> priorityMethods = this.getMethodsAnnotatedWith(Priority.class, rule);
        if (priorityMethods.isEmpty()) {
            return;
        }
        if (priorityMethods.size() > 1) {
            throw new IllegalArgumentException(String.format("Rule '%s' must have exactly one method annotated with '%s'", rule.getClass().getName(), Priority.class.getName()));
        }
        Method priorityMethod = priorityMethods.get(0);
        if (!this.isPriorityMethodWellDefined(priorityMethod)) {
            throw new IllegalArgumentException(String.format("Priority method '%s' defined in rule '%s' must be public, have no parameters and return integer type.", priorityMethod, rule.getClass().getName()));
        }
    }

    private void checkRuleClass(Object rule) {
        if (!this.isRuleClassWellDefined(rule)) {
            throw new IllegalArgumentException(String.format("Rule '%s' is not annotated with '%s'", rule.getClass().getName(), Rule.class.getName()));
        }
    }

    private Method[] getMethods(Object rule) {
        return rule.getClass().getMethods();
    }

    private List<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation, Object rule) {
        Method[] methods = this.getMethods(rule);
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotation)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    private Parameter getNotAnnotatedParameter(Method method) {
        Parameter[] parameters;
        for (Parameter parameter : parameters = method.getParameters()) {
            if (parameter.getAnnotations().length != 0) continue;
            return parameter;
        }
        return null;
    }

    private boolean isActionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Void.TYPE) && this.validParameters(method);
    }

    private boolean isConditionMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Boolean.TYPE) && this.validParameters(method);
    }

    private boolean isPriorityMethodWellDefined(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getReturnType().equals(Integer.TYPE) && method.getParameterTypes().length == 0;
    }

    private boolean isRuleClassWellDefined(Object rule) {
        return Utils.isAnnotationPresent(Rule.class, rule.getClass());
    }

    void validateRuleDefinition(Object rule) {
        this.checkRuleClass(rule);
        this.checkConditionMethod(rule);
        this.checkActionMethods(rule);
        this.checkPriorityMethod(rule);
    }

    private boolean validParameters(Method method) {
        Parameter notAnnotatedParameter;
        Annotation[][] parameterAnnotations;
        int notAnnotatedParameterCount = 0;
        for (Annotation[] annotations : parameterAnnotations = method.getParameterAnnotations()) {
            if (annotations.length == 0) {
                ++notAnnotatedParameterCount;
                continue;
            }
            for (Annotation annotation : annotations) {
                if (annotation.annotationType().equals(Fact.class)) continue;
                return false;
            }
        }
        if (notAnnotatedParameterCount > 1) {
            return false;
        }
        if (notAnnotatedParameterCount == 1 && (notAnnotatedParameter = this.getNotAnnotatedParameter(method)) != null) {
            return Facts.class.isAssignableFrom(notAnnotatedParameter.getType());
        }
        return true;
    }
}

