/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.UnknownHostException;
import java.util.HashSet;
import org.rossonet.utils.TextHelper;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

public class DataInDnsHelper {
    private static final String CHUNK_NUMBER_SUFFIX = "-idx";

    public static String getStringFromDnsHostRecord(String hostNamePrefix, String domain, int retry) throws TextParseException, UnknownHostException {
        StringBuilder resultString = new StringBuilder();
        HashSet<CallSite> errors = new HashSet<CallSite>();
        Lookup l = new Lookup(hostNamePrefix + "-idx." + domain, 16, 1);
        l.setResolver((Resolver)new SimpleResolver());
        l.run();
        if (l.getResult() == 0) {
            int chunkSize = Integer.parseInt(l.getAnswers()[0].rdataToString().replaceAll("^\"", "").replaceAll("\"$", ""));
            if (chunkSize > 0) {
                for (int c = 0; c < chunkSize; ++c) {
                    Lookup cl = new Lookup(hostNamePrefix + "-" + String.valueOf(c) + "." + domain, 16, 1);
                    cl.setResolver((Resolver)new SimpleResolver());
                    cl.run();
                    if (cl.getResult() == 0) {
                        resultString.append(cl.getAnswers()[0].rdataToString().replaceAll("^\"", "").replaceAll("\"$", ""));
                        continue;
                    }
                    errors.add((CallSite)((Object)("error in chunk " + hostNamePrefix + "-" + String.valueOf(c) + "." + domain + " -> " + cl.getErrorString())));
                }
            } else {
                errors.add((CallSite)((Object)("error, size of data is " + l.getAnswers()[0].rdataToString())));
            }
        } else {
            errors.add((CallSite)((Object)("no " + hostNamePrefix + "-idx." + domain + " record found -> " + l.getErrorString())));
            if (retry > 0) {
                return DataInDnsHelper.getStringFromDnsHostRecord(hostNamePrefix, domain, retry - 1);
            }
            return null;
        }
        if (!errors.isEmpty()) {
            throw new RuntimeException(TextHelper.joinCollection(errors, "\n"));
        }
        return resultString.toString();
    }

    public static String prepareStringAsDnsHostRecord(String hostNamePrefix, String data) throws IOException {
        Iterable chunks = Splitter.fixedLength((int)254).split((CharSequence)data);
        StringBuilder result = new StringBuilder();
        int counter = 0;
        for (String s : chunks) {
            result.append(hostNamePrefix + "-" + String.valueOf(counter) + "\tIN\tTXT\t\"" + s + "\"\n");
            ++counter;
        }
        result.append(hostNamePrefix + "-idx\tIN\tTXT\t\"" + String.valueOf(counter) + "\"\n");
        return result.toString();
    }

    private DataInDnsHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

