/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public final class TextHelper {
    private static final String ENCRYPTION_ALGORITHM = "AES";

    public static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    public static byte[] decryptData(byte[] encryptedData, byte[] key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher c = Cipher.getInstance(ENCRYPTION_ALGORITHM);
        SecretKeySpec k = new SecretKeySpec(key, ENCRYPTION_ALGORITHM);
        c.init(2, k);
        return c.doFinal(encryptedData);
    }

    public static void deleteDirectory(File file) {
        if (Files.exists(Paths.get(file.getAbsolutePath(), new String[0]), new LinkOption[0])) {
            for (File subfile : file.listFiles()) {
                if (subfile.isDirectory()) {
                    TextHelper.deleteDirectory(subfile);
                }
                subfile.delete();
            }
        }
    }

    public static byte[] encryptData(byte[] dataToEncrypt, byte[] key) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher c = Cipher.getInstance(ENCRYPTION_ALGORITHM);
        SecretKeySpec k = new SecretKeySpec(key, ENCRYPTION_ALGORITHM);
        c.init(1, k);
        return c.doFinal(dataToEncrypt);
    }

    public static JSONObject getJsonFromMap(Map<String, String> map) {
        JSONObject json = new JSONObject();
        for (String key : map.keySet()) {
            json.put(key, (Object)map.get(key));
        }
        return json;
    }

    public static Map<String, String> getMapFromJson(JSONObject jsonMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : jsonMap.keySet()) {
            map.put(key, jsonMap.getString(key));
        }
        return map;
    }

    public static Map<String, String> getParametersInUrlQuery(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    public static <O extends Serializable> O objectFromString(String string, Class<O> clazz) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(string);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return (O)((Serializable)o);
    }

    public static String objectToString(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    public static List<String> splitFixSize(String s, int chunkSize) {
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i < s.length(); i += chunkSize) {
            chunks.add(s.substring(i, Math.min(s.length(), i + chunkSize)));
        }
        return chunks;
    }

    private TextHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

