/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class OtpHelper {
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    public static boolean checkTOTP(String seedOTP, String otpCode, int finestraOTP, String returnDigits) {
        boolean result = false;
        ArrayList<String> validOtps = new ArrayList<String>();
        long millisec = new Date().getTime();
        long end = millisec + Long.valueOf(finestraOTP * 500);
        for (long counter = millisec - Long.valueOf(finestraOTP * 500); counter <= end; ++counter) {
            validOtps.add(OtpHelper.generateTOTP512(seedOTP, String.valueOf(counter), returnDigits));
        }
        result = validOtps.contains(otpCode);
        return result;
    }

    public static String generateTOTP(String key, String time, String returnDigits) {
        return OtpHelper.generateTOTP(key, time, returnDigits, "HmacSHA1");
    }

    public static String generateTOTP(String key, String time, String returnDigits, String crypto) {
        int codeDigits = Integer.decode(returnDigits);
        String result = null;
        while (time.length() < 16) {
            time = "0" + time;
        }
        byte[] msg = OtpHelper.hexStr2Bytes(time);
        byte[] k = OtpHelper.hexStr2Bytes(key);
        byte[] hash = OtpHelper.hmac_sha(crypto, k, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[codeDigits];
        result = Integer.toString(otp);
        while (result.length() < codeDigits) {
            result = "0" + result;
        }
        return result;
    }

    public static String generateTOTP256(String key, String time, String returnDigits) {
        return OtpHelper.generateTOTP(key, time, returnDigits, "HmacSHA256");
    }

    public static String generateTOTP512(String key, String time, String returnDigits) {
        return OtpHelper.generateTOTP(key, time, returnDigits, "HmacSHA512");
    }

    public static String getRandomHexString(int numchars) {
        Random r = new Random();
        StringBuffer sb = new StringBuffer();
        while (sb.length() < numchars) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, numchars);
    }

    private static byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bArray[i + 1];
        }
        return ret;
    }

    private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    private OtpHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

