/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rossonet.utils.LogHelper;

public final class NetworkHelper {
    private static final Logger logger = Logger.getLogger(NetworkHelper.class.getName());
    private static final Long[] SUBNET_MASK = new Long[]{0xFFFF8000L, 0xFFFFC000L, 0xFFFFE000L, 0xFFFFF000L, 0xFFFFF800L, 0xFFFFFC00L, 0xFFFFFE00L, 0xFFFFFF00L, 0xFFFFFF80L, 0xFFFFFFC0L, 0xFFFFFFE0L, 0xFFFFFFF0L, 0xFFFFFFF8L, 0xFFFFFFFCL, 0xFFFFFFFEL, 0xFFFFFFFFL};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkLocalPortAvailable(int port) {
        boolean portTaken = false;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            socket.setReuseAddress(true);
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            portTaken = true;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.severe(e.getMessage());
                }
            }
        }
        return !portTaken;
    }

    public static int findAvailablePort(int defaultPort) {
        try {
            ServerSocket socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (IOException ex) {
            logger.severe(ex.getMessage());
            return defaultPort;
        }
    }

    public static List<String> getAllNetworkMacAddress() throws SocketException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            byte[] hardwareAddress = ni.getHardwareAddress();
            if (hardwareAddress == null) continue;
            CharSequence[] hexadecimalFormat = new String[hardwareAddress.length];
            for (int i = 0; i < hardwareAddress.length; ++i) {
                hexadecimalFormat[i] = String.format("%02X", hardwareAddress[i]);
            }
            result.add(String.join((CharSequence)"-", hexadecimalFormat));
        }
        return result;
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.severe(e.getMessage());
            return "localhost";
        }
    }

    public static Set<String> getHostnames(String address) {
        HashSet<String> hostnames;
        block6: {
            hostnames = new HashSet<String>();
            try {
                InetAddress inetAddress = InetAddress.getByName(address);
                if (inetAddress.isAnyLocalAddress()) {
                    try {
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        for (NetworkInterface ni : Collections.list(nis)) {
                            Collections.list(ni.getInetAddresses()).forEach(ia -> {
                                if (ia instanceof Inet4Address) {
                                    hostnames.add(ia.getHostName());
                                    hostnames.add(ia.getHostAddress());
                                    hostnames.add(ia.getCanonicalHostName());
                                }
                            });
                        }
                        break block6;
                    }
                    catch (SocketException e) {
                        logger.severe(e.getMessage());
                        break block6;
                    }
                }
                hostnames.add(inetAddress.getHostName());
                hostnames.add(inetAddress.getHostAddress());
                hostnames.add(inetAddress.getCanonicalHostName());
            }
            catch (UnknownHostException e) {
                logger.severe(e.getMessage());
            }
        }
        return hostnames;
    }

    public static String getMacAddressAsString(String hostname) {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(hostname);
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network != null) {
                byte[] mac = network.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], ""));
                }
                return sb.toString().toLowerCase();
            }
            return "xxxxxx";
        }
        catch (Exception e) {
            logger.info("searching mac of " + ip + "\n" + LogHelper.stackTraceToString(e));
            return "xxxxxx";
        }
    }

    public static boolean isValidIPAddress(String ip) {
        String zeroTo255 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String regex = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        Pattern p = Pattern.compile("(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])");
        if (ip == null) {
            return false;
        }
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    public static boolean isValidMacAddress(String macAddress) {
        String regex = "^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})|([0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}\\.[0-9a-fA-F]{4})$";
        Pattern p = Pattern.compile("^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})|([0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}\\.[0-9a-fA-F]{4})$");
        if (macAddress == null) {
            return false;
        }
        Matcher m = p.matcher(macAddress);
        return m.matches();
    }

    public static boolean isValidSubnetMask(String subnetMask) {
        long lSubnetMask;
        if (subnetMask != null && NetworkHelper.isValidIPAddress(subnetMask) && (lSubnetMask = NetworkHelper.ipAddressToLong(subnetMask)) > 0L) {
            return Arrays.asList(SUBNET_MASK).contains(lSubnetMask);
        }
        return false;
    }

    private static long ipAddressToLong(String ipAddress) {
        String[] s;
        if (ipAddress != null && (s = ipAddress.split("\\.")) != null && s.length == 4) {
            long result = 0L;
            for (int i = 3; i >= 0; --i) {
                try {
                    long n = Long.parseLong(s[3 - i]);
                    result |= n << i * 8;
                    continue;
                }
                catch (Exception ex) {
                    return -1L;
                }
            }
            return result;
        }
        return -1L;
    }

    private NetworkHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

