/*
 * Decompiled with CFR 0.152.
 */
package org.rossonet.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;

public final class LogHelper {
    public static void changeLogLevel(String logLevel) throws ConfigurationException {
        Logger rootLogger = Logger.getLogger("");
        Level targetLevel = Level.INFO;
        switch (logLevel) {
            case "all": {
                targetLevel = Level.ALL;
                break;
            }
            case "config": {
                targetLevel = Level.CONFIG;
                break;
            }
            case "fine": {
                targetLevel = Level.FINE;
                break;
            }
            case "finer": {
                targetLevel = Level.FINER;
                break;
            }
            case "finest": {
                targetLevel = Level.FINEST;
                break;
            }
            case "info": {
                targetLevel = Level.INFO;
                break;
            }
            case "off": {
                targetLevel = Level.OFF;
                break;
            }
            case "severe": {
                targetLevel = Level.SEVERE;
                break;
            }
            case "warning": {
                targetLevel = Level.WARNING;
                break;
            }
            default: {
                throw new ConfigurationException("log level " + (String)logLevel + " not exists. You can use: all, config, fine, finer, finest, info, off, severe or warning");
            }
        }
        rootLogger.setLevel(targetLevel);
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(targetLevel);
        }
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String response = null;
        response = throwable.getCause() != null && throwable.getCause().getMessage() != null ? " [M] " + throwable.getCause().getMessage() + " -> " + sw.toString() : " [M] " + sw.toString();
        return response;
    }

    public static String stackTraceToString(Throwable throwable, int numLines) {
        try {
            List<String> lines = Arrays.asList(LogHelper.stackTraceToString(throwable).split("\n"));
            ArrayList<String> al = new ArrayList<String>(lines.subList(0, Math.min(lines.size(), numLines)));
            StringBuilder returnString = new StringBuilder();
            for (String line : al) {
                returnString.append(line + "\n");
            }
            return returnString.toString();
        }
        catch (Exception n) {
            return LogHelper.stackTraceToString(throwable);
        }
    }

    private LogHelper() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

