/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.plugin.api.template;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.plugin.api.internal.template.InstanceBean;

public final class InstanceTemplateHelper {
    private InstanceTemplateHelper() {
    }

    public static void injectInstanceImports(Instance instance, File templateFile, Writer writer) throws IOException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory(templateFile.getParentFile());
        Mustache mustache = mf.compile(templateFile.getName());
        mustache.execute(writer, new InstanceBean(instance)).flush();
    }

    public static void injectInstanceImports(Instance instance, String templateFilePath, Writer writer) throws IOException {
        InstanceTemplateHelper.injectInstanceImports(instance, new File(templateFilePath), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectInstanceImports(Instance instance, String templateFilePath, File targetFile) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(targetFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8").newEncoder());
            InstanceTemplateHelper.injectInstanceImports(instance, templateFilePath, (Writer)writer);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(os);
            throw throwable;
        }
        Utils.closeQuietly((OutputStream)os);
    }

    public static void injectInstanceImports(Instance instance, File templateFile, File out) throws IOException {
        InstanceTemplateHelper.injectInstanceImports(instance, templateFile.getAbsolutePath(), out);
    }
}

