/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.rostore.Utils;
import org.rostore.mapper.BlockIndex;
import org.rostore.mapper.BlockOffset;
import org.rostore.mapper.MapperProperties;

public class BinaryMapper {
    private static final int MAX_BYTES_FOR_LENGTH = 4;
    private static final Map<Class, Serializer> serializers = Map.of(Long.TYPE, (field, object, data, mp) -> BinaryMapper.write(data, field.getLong(object), BinaryMapper.getLongBytes(field, mp)), Integer.TYPE, (field, object, data, mp) -> BinaryMapper.write(data, field.getInt(object), 4), Short.TYPE, (field, object, data, mp) -> BinaryMapper.write(data, field.getLong(object), 2), Byte.TYPE, (field, object, data, mp) -> data.write(field.getByte(object)));
    private static final Map<Class, Deserializer> deserializers = Map.of(Long.TYPE, (field, object, data, mp) -> field.setLong(object, BinaryMapper.read(data, BinaryMapper.getLongBytes(field, mp))), Integer.TYPE, (field, object, data, mp) -> field.setInt(object, (int)BinaryMapper.read(data, 4)), Short.TYPE, (field, object, data, mp) -> field.setShort(object, (short)BinaryMapper.read(data, 2)), Byte.TYPE, (field, object, data, mp) -> field.setByte(object, (byte)data.read()));

    private static int getLongBytes(Field field, MapperProperties mediaProperties) {
        int bytes = 8;
        if (field.getAnnotation(BlockIndex.class) != null) {
            bytes = mediaProperties.getBytesPerBlockIndex();
        } else if (field.getAnnotation(BlockOffset.class) != null) {
            bytes = mediaProperties.getBytesPerBlockOffset();
        }
        return bytes;
    }

    public static void write(OutputStream data, String value) throws IOException {
        if (value == null) {
            BinaryMapper.writeLength(data, -1);
        } else {
            byte[] valueData = value.getBytes(StandardCharsets.UTF_8);
            BinaryMapper.writeLength(data, valueData.length);
            data.write(valueData);
        }
    }

    public static void writeLength(OutputStream data, int dataLength) throws IOException {
        if (dataLength == -1) {
            BinaryMapper.write(data, 0L, 1);
        } else if (dataLength <= 122) {
            int length = dataLength + 4 + 1;
            BinaryMapper.write(data, length, 1);
        } else {
            int lengthOfLength = Utils.computeBytesForMaxValue(dataLength);
            BinaryMapper.write(data, lengthOfLength, 1);
            BinaryMapper.write(data, dataLength, lengthOfLength);
        }
    }

    public static String readString(InputStream data) throws IOException {
        int length = BinaryMapper.readLength(data);
        if (length == -1) {
            return null;
        }
        byte[] valueData = new byte[length];
        data.read(valueData);
        return new String(valueData);
    }

    public static int readLength(InputStream data) throws IOException {
        int lengthOfLength = (int)BinaryMapper.read(data, 1);
        if (lengthOfLength == 0) {
            return -1;
        }
        if (lengthOfLength > 4) {
            return lengthOfLength - 4 - 1;
        }
        return (int)BinaryMapper.read(data, lengthOfLength);
    }

    public static <T> void serialize(MapperProperties mediaProperties, T object, OutputStream outputStream) {
        if (object == null) {
            throw new RuntimeException("This function can only be used to serialize a non-null object");
        }
        BinaryMapper.serialize(mediaProperties, object, object.getClass(), outputStream);
    }

    public static <T> void serialize(MapperProperties mediaProperties, T object, Type type, OutputStream outputStream) {
        Class clazz = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
        try {
            if (clazz.isEnum()) {
                Object[] enumConsts = clazz.getEnumConstants();
                int bytes = Utils.computeBytesForMaxValue(enumConsts.length);
                if (object == null) {
                    BinaryMapper.write(outputStream, 0L, bytes);
                } else {
                    int i = Arrays.binarySearch(enumConsts, object);
                    BinaryMapper.write(outputStream, i + 1, bytes);
                }
                return;
            }
            if (clazz.isAssignableFrom(String.class)) {
                BinaryMapper.write(outputStream, (String)object);
                return;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                Collection l = (Collection)object;
                if (l == null) {
                    BinaryMapper.writeLength(outputStream, -1);
                } else {
                    Type argType = ((ParameterizedType)type).getActualTypeArguments()[0];
                    BinaryMapper.writeLength(outputStream, l.size());
                    for (Object o : l) {
                        BinaryMapper.serialize(mediaProperties, o, argType, outputStream);
                    }
                }
                return;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Map map = (Map)object;
                if (map == null) {
                    BinaryMapper.writeLength(outputStream, -1);
                } else {
                    Type[] args = ((ParameterizedType)type).getActualTypeArguments();
                    Type argTypeLeft = args[0];
                    Type argTypeRight = args[1];
                    BinaryMapper.writeLength(outputStream, map.size());
                    Set entries = map.entrySet();
                    for (Map.Entry o : entries) {
                        BinaryMapper.serialize(mediaProperties, o.getKey(), argTypeLeft, outputStream);
                        BinaryMapper.serialize(mediaProperties, o.getValue(), argTypeRight, outputStream);
                    }
                }
                return;
            }
            if (object == null) {
                BinaryMapper.write(outputStream, 0L, 1);
                return;
            }
            BinaryMapper.write(outputStream, 1L, 1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (BinaryMapper.isIgnore(field)) continue;
            try {
                field.setAccessible(true);
                Serializer serializer = serializers.get(field.getType());
                if (serializer != null) {
                    serializer.map(field, object, outputStream, mediaProperties);
                    continue;
                }
                Object nextObject = field.get(object);
                BinaryMapper.serialize(mediaProperties, nextObject, field.getGenericType(), outputStream);
            }
            catch (Exception runtimeException) {
                throw new IllegalStateException("Field " + field.getName() + " of type " + String.valueOf(field.getType()) + " can't be serialized", runtimeException);
            }
        }
    }

    public static <T> T deserialize(MapperProperties mediaProperties, Type type, InputStream inputStream) {
        return BinaryMapper.deserialize(mediaProperties, type, inputStream, 0);
    }

    public static <T> T deserialize(MapperProperties mapperProperties, Type type, InputStream inputStream, int limit) {
        try {
            Class clazz = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
            if (clazz.isEnum()) {
                T[] enumConsts = clazz.getEnumConstants();
                int bytes = Utils.computeBytesForMaxValue(enumConsts.length);
                int ordinal = (int)BinaryMapper.read(inputStream, bytes);
                if (ordinal == 0) {
                    return null;
                }
                return enumConsts[ordinal - 1];
            }
            if (String.class.equals((Object)clazz)) {
                return (T)BinaryMapper.readString(inputStream);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                int length = BinaryMapper.readLength(inputStream);
                if (length == -1) {
                    return null;
                }
                Type argType = ((ParameterizedType)type).getActualTypeArguments()[0];
                Class argClass = null;
                if (argType instanceof Class) {
                    argClass = (Class)argType;
                }
                AbstractCollection l = null;
                if (List.class.isAssignableFrom(clazz)) {
                    l = new ArrayList(length);
                } else if (Set.class.isAssignableFrom(clazz)) {
                    l = argClass != null && argClass.isEnum() ? EnumSet.noneOf(argClass) : new HashSet();
                }
                if (l == null) {
                    throw new RuntimeException("Can't instantiate " + String.valueOf(clazz));
                }
                for (int i = 0; i < length; ++i) {
                    T obj = BinaryMapper.deserialize(mapperProperties, argType, inputStream);
                    l.add(obj);
                }
                return (T)l;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                int length = BinaryMapper.readLength(inputStream);
                if (length == -1) {
                    return null;
                }
                Type[] args = ((ParameterizedType)type).getActualTypeArguments();
                Type argTypeLeft = args[0];
                Type argTypeRight = args[1];
                Class argClassLeft = null;
                if (argTypeLeft instanceof Class) {
                    argClassLeft = (Class)argTypeLeft;
                }
                AbstractMap map = null;
                map = argClassLeft != null && argClassLeft.isEnum() ? new EnumMap(argClassLeft) : (NavigableMap.class.isAssignableFrom(clazz) ? new TreeMap() : new HashMap());
                if (map == null) {
                    throw new RuntimeException("Can't instantiate " + String.valueOf(clazz));
                }
                for (int i = 0; i < length; ++i) {
                    T key = BinaryMapper.deserialize(mapperProperties, argTypeLeft, inputStream);
                    T value = BinaryMapper.deserialize(mapperProperties, argTypeRight, inputStream);
                    map.put(key, value);
                }
                return (T)map;
            }
            long nullValue = BinaryMapper.read(inputStream, 1);
            if (nullValue == 0L) {
                return null;
            }
            int count = 0;
            Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : object.getClass().getDeclaredFields()) {
                if (BinaryMapper.isIgnore(field)) continue;
                field.setAccessible(true);
                Deserializer deserializer = deserializers.get(field.getType());
                if (deserializer != null) {
                    try {
                        deserializer.map(field, object, inputStream, mapperProperties);
                    }
                    catch (Exception runtimeException) {
                        throw new IllegalStateException("Field " + field.getName() + " of type " + String.valueOf(field.getType()) + " can't be deserialized", runtimeException);
                    }
                } else {
                    Type genericType = field.getGenericType();
                    T nextObject = BinaryMapper.deserialize(mapperProperties, genericType, inputStream);
                    field.set(object, nextObject);
                }
                if (limit != 0 && ++count >= limit) break;
            }
            return object;
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isIgnore(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    private static void write(OutputStream outputStream, long value, int number) throws IOException {
        for (int i = 0; i < number; ++i) {
            int b = (int)(value & 0xFFL);
            outputStream.write(b);
            value >>= 8;
        }
    }

    private static long read(InputStream inputStream, int number) throws IOException {
        long result = 0L;
        for (int i = 0; i < number; ++i) {
            long b = inputStream.read() & 0xFF;
            result |= (b <<= 8 * i);
        }
        return result;
    }

    private static interface Serializer {
        public void map(Field var1, Object var2, OutputStream var3, MapperProperties var4) throws IllegalAccessException, IOException;
    }

    private static interface Deserializer {
        public void map(Field var1, Object var2, InputStream var3, MapperProperties var4) throws IllegalAccessException, IOException;
    }
}

