/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.entity.apikey;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.rostore.entity.apikey.Permission;

@Schema(description="Permissions associated with APIKEY")
public class ApiKeyPermissions {
    @Schema(description="Permissions granted per container", example="{ \"yourStoreName\": [\"READ\", \"LIST\",\"WRITE\",\"DELETE\",\"CREATE\",\"GRANT\"] }")
    private Map<String, Set<Permission>> containerPermissions = new HashMap<String, Set<Permission>>();
    @Schema(description="Permissions granted on store", example=" [\"READ\", \"LIST\",\"WRITE\",\"DELETE\",\"CREATE\",\"GRANT\",\"SUPER\"] ")
    private Set<Permission> storePermissions = EnumSet.noneOf(Permission.class);

    public Set<Permission> getContainerPermissions(String containerName) {
        return this.containerPermissions.get(containerName);
    }

    public Map<String, Set<Permission>> getContainerPermissions() {
        return this.containerPermissions;
    }

    public void setContainerPermissions(Map<String, Set<Permission>> containerPermissions) {
        this.containerPermissions = containerPermissions;
    }

    public void setContainerPermissions(String containerName, Set<Permission> containerPermissions) {
        this.containerPermissions.put(containerName, containerPermissions);
    }

    public void setStorePermissions(Set<Permission> storagePermissions) {
        this.storePermissions = storagePermissions;
    }

    public Set<Permission> getStorePermissions() {
        return this.storePermissions;
    }

    public String toString() {
        return "ApiKeyPermissions{containerPermissions=" + String.valueOf(this.containerPermissions) + ", storePermissions=" + String.valueOf(this.storePermissions) + "}";
    }
}

