/*
 * Decompiled with CFR 0.152.
 */
package org.rostore;

import java.nio.charset.Charset;

public class Utils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final long TTL_START = 1595776424L;
    public static final int BYTES_PER_EOL = 4;
    public static final int BYTES_PER_VERSION = 1;
    public static final long TTL_FOREVER = 0L;
    public static final long TTL_EXPIRED = 0L;
    public static final long EOL_FOREVER = 0L;
    public static final long VERSION_UNDEFINED = 0L;
    public static final long VERSION_START = 1L;
    public static final long ID_UNDEFINED = -1L;

    public static byte[] getBytes(String str) {
        return str == null ? null : str.getBytes(UTF_8);
    }

    public static final long ttl2eol(long ttl) {
        if (ttl == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - 1595776424L + ttl;
    }

    public static final long ttl2unixEol(long ttl) {
        if (ttl == 0L) {
            return 0L;
        }
        return (System.currentTimeMillis() / 1000L + ttl) * 1000L;
    }

    public static final long eol2ttl(long eol) {
        if (eol == 0L) {
            return 0L;
        }
        long ttl = eol + 1595776424L - System.currentTimeMillis() / 1000L;
        if (ttl <= 0L) {
            return 0L;
        }
        return ttl;
    }

    public static final long eol2unix(long eol) {
        if (eol == 0L) {
            return 0L;
        }
        return (eol + 1595776424L) * 1000L;
    }

    public static final boolean isExpiredEOL(long eol) {
        return Utils.isExpiredEOL(eol, System.currentTimeMillis() / 1000L);
    }

    public static final boolean isExpiredEOL(long eol, long currentTimeSecs) {
        if (eol == 0L) {
            return false;
        }
        return eol + 1595776424L < currentTimeSecs;
    }

    public static int computeBytesForMaxValue(long maxValue) {
        int byteNumber = 0;
        for (int i = 0; i < 8; ++i) {
            long mask = 255L;
            mask <<= i * 8;
            if ((mask &= maxValue) == 0L) continue;
            byteNumber = i + 1;
        }
        return byteNumber;
    }

    public static long trimByBytes(long value, int bytes) {
        long ret = 0L;
        long mask = 255L;
        for (int i = 0; i < bytes; ++i) {
            ret |= value & mask;
            mask <<= 8;
        }
        return ret;
    }

    public static long unixEol2eol(long unixEol) {
        return unixEol / 1000L - 1595776424L;
    }
}

