/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.seq;

import java.util.function.Function;
import org.rostore.entity.RoStoreException;
import org.rostore.v2.catalog.CatalogBlockIndices;
import org.rostore.v2.media.Closeable;
import org.rostore.v2.media.block.Block;
import org.rostore.v2.media.block.BlockProvider;
import org.rostore.v2.media.block.BlockType;
import org.rostore.v2.media.block.container.Status;
import org.rostore.v2.seq.BlockIndexSequence;
import org.rostore.v2.seq.BlockSequence;

public abstract class SequenceBlock
implements Closeable {
    private int index;
    private final BlockSequence blockSequence;

    public BlockSequence getBlockSequence() {
        return this.blockSequence;
    }

    private void throwExceptionIfInvalid(String message) {
        if (this.invalid()) {
            throw new RoStoreException("The <" + String.valueOf(this) + "> is invalid: " + message);
        }
    }

    public static <T extends SequenceBlock> T load(BlockProvider blockProvider, long startIndex, Function<BlockSequence<T>, T> factory, BlockType blockType) {
        return blockProvider.getMedia().getBlockIndexSequences().get(startIndex, blockIndexSequence -> {
            if (blockIndexSequence == null) {
                return new BlockSequence(blockProvider, startIndex, factory, blockType);
            }
            return new BlockSequence(blockProvider, (BlockIndexSequence)blockIndexSequence, factory, blockType);
        }).getSequenceBlock();
    }

    public static <T extends SequenceBlock> T create(BlockProvider blockProvider, Function<BlockSequence<T>, T> factory, BlockType blockType) {
        return blockProvider.getMedia().getBlockIndexSequences().get(-1L, blockIndexSequence -> {
            CatalogBlockIndices catalogBlockIndices = blockProvider.getBlockAllocator().allocate(blockType, 4);
            return new BlockSequence(blockProvider, catalogBlockIndices, factory, blockType);
        }).getSequenceBlock();
    }

    public static <T extends SequenceBlock> T create(BlockProvider blockProvider, CatalogBlockIndices catalogBlockIndices, Function<BlockSequence<T>, T> factory, BlockType blockType) {
        return blockProvider.getMedia().getBlockIndexSequences().get(-1L, blockIndexSequence -> new BlockSequence(blockProvider, catalogBlockIndices, factory, blockType)).getSequenceBlock();
    }

    public int getHeaderSize() {
        return this.blockSequence.getBlockProvider().getMedia().getMediaProperties().getMapperProperties().getBytesPerBlockIndex();
    }

    public void previous() {
        this.throwExceptionIfInvalid("previous");
        if (this.index > 0) {
            this.moveTo(this.index - 1);
            return;
        }
        this.invalidate();
    }

    public void next() {
        this.throwExceptionIfInvalid("next");
        if (this.index < this.blockSequence.length() - 1) {
            this.moveTo(this.index + 1);
            return;
        }
        this.invalidate();
    }

    public void last() {
        if (this.blockSequence.length() != 0) {
            this.moveTo(this.blockSequence.length() - 1);
        } else {
            this.invalidate();
        }
    }

    public void root() {
        if (this.blockSequence.length() != 0) {
            this.moveTo(0);
        } else {
            this.invalidate();
        }
    }

    public void invalidate() {
        this.index = -1;
    }

    public void moveTo(int seqIndex) {
        if (seqIndex >= 0 && seqIndex < this.blockSequence.getBlockIndexSequence().length()) {
            this.checkOpened();
            this.index = seqIndex;
        } else {
            this.invalidate();
        }
    }

    public boolean isRoot() {
        this.throwExceptionIfInvalid("isRoot");
        return this.index == 0;
    }

    public int getIndex() {
        this.throwExceptionIfInvalid("getIndex");
        return this.index;
    }

    protected SequenceBlock(BlockSequence blockSequence) {
        this.blockSequence = blockSequence;
        if (blockSequence.length() > 0) {
            this.moveTo(0);
        } else {
            this.invalidate();
        }
    }

    public boolean invalid() {
        return this.index == -1;
    }

    public boolean valid() {
        return this.index != -1;
    }

    public Block getBlock() {
        this.throwExceptionIfInvalid("getBlock");
        return this.blockSequence.getBlockByIndex(this.index);
    }

    public void delete() {
        this.throwExceptionIfInvalid("delete");
        this.blockSequence.removeFreeBlock(this.getIndex());
    }

    public void createNewAfter() {
        this.throwExceptionIfInvalid("createNewAfter");
        this.blockSequence.addFreeBlock(this.getIndex());
        this.next();
    }

    protected abstract boolean isUnused();

    protected void clean() {
        this.getBlock().clean();
    }

    @Override
    public void close() {
        this.blockSequence.close();
    }

    @Override
    public Status getStatus() {
        return this.blockSequence.getStatus();
    }
}

